/*
 * Decompiled with CFR 0.152.
 */
package org.creekservice.api.system.test.extension.test.env.suite.service;

import java.util.Objects;
import java.util.Optional;
import org.creekservice.api.platform.metadata.ServiceDescriptor;

public interface ServiceInstance {
    public String name();

    public Optional<? extends ServiceDescriptor> descriptor();

    public void start();

    public boolean running();

    public void stop();

    public int testNetworkPort(int var1);

    public String testNetworkHostname();

    public String serviceNetworkHostname();

    public ExecResult execOnInstance(String ... var1);

    public static final class ExecResult {
        private final int exitCode;
        private final String stdout;
        private final String stderr;

        public static ExecResult execResult(int exitCode, String stdout, String stderr) {
            return new ExecResult(exitCode, stdout, stderr);
        }

        private ExecResult(int exitCode, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.stdout = Objects.requireNonNull(stdout, "stdout");
            this.stderr = Objects.requireNonNull(stderr, "stderr");
        }

        public int exitCode() {
            return this.exitCode;
        }

        public String stdout() {
            return this.stdout;
        }

        public String stderr() {
            return this.stderr;
        }

        public String toString() {
            return "ExecResult{exitCode=" + this.exitCode + ", stderr='" + this.stderr + "', stdout='" + this.stdout + "'}";
        }
    }
}

