/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.tokenizer;

import junit.framework.TestCase;
import org.crsh.cmdline.matcher.tokenizer.Token;
import org.crsh.cmdline.matcher.tokenizer.Tokenizer;
import org.crsh.cmdline.matcher.tokenizer.TokenizerImpl;

public class TokenizerTestCase
extends TestCase {
    private void assertDone(Tokenizer tokenizer) {
        if (tokenizer.hasNext()) {
            Token next = tokenizer.next();
            TokenizerTestCase.fail((String)("Was not expecting " + next));
        }
    }

    public void testEmpty() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"");
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testWhitespace1() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)" ");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testWhitespace2() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"  ");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, "  "), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testWord1() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testWord2() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"ab");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "ab"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testWord3() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)" a");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(1, "a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testWord4() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"-1");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "-1"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testWord5() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"--1");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "--1"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testWord6() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"a ");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a"), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(1, " "), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testQuotedWord1() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\"a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "\"a", "a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
        tokenizer = new TokenizerImpl((CharSequence)"'a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "'a", "a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testQuotedWord2() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\"a \"");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "\"a \"", "a "), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
        tokenizer = new TokenizerImpl((CharSequence)"'a '");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "'a '", "a "), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testQuotedWord3() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"a\" \"b");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a\" \"b", "a b"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
        tokenizer = new TokenizerImpl((CharSequence)"a' 'b");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a' 'b", "a b"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testQuotedWord4() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\"-a\"");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(0, "\"-a\"", "-a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
        tokenizer = new TokenizerImpl((CharSequence)"'-a'");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(0, "'-a'", "-a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testQuotedWord5() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\"--a\"");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(0, "\"--a\"", "--a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
        tokenizer = new TokenizerImpl((CharSequence)"'--a'");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(0, "'--a'", "--a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testQuotedWord6() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\"'\"");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "\"'\"", "'"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
        tokenizer = new TokenizerImpl((CharSequence)"'\"'");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "'\"'", "\""), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testQuotedWord7() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"a\"\"b");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a\"\"b", "ab"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
        tokenizer = new TokenizerImpl((CharSequence)"a''b");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a''b", "ab"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testEmptyShortOption() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"-");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(0, "-", "-"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testShortOption1() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"-a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(0, "-a", "-a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testShortOption2() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"-ab");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(0, "-ab", "-ab"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testShortOption3() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)" -a");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(1, "-a", "-a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testShortOption4() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"- ");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(0, "-", "-"), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(1, " "), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testEmptyLongOption1() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"--");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(0, "--", "--"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testEmptyLongOption2() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"-- ");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(0, "--", "--"), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(2, " "), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testLongOption1() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"--a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(0, "--a", "--a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testLongOption2() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"--ab");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(0, "--ab", "--ab"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testLongOption3() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)" --a");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(1, "--a", "--a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testBackSlash1() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\\a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "\\a", "a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testBackSlash2() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\\ ");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "\\ ", " "), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testBackSlash3() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\\-a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(0, "\\-a", "-a"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testEmptyWord1() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\"\"");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "\"\"", ""), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testEmptyWord2() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)" \"\"");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(1, "\"\"", ""), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testEmptyWord3() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"\"\"\"\"");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "\"\"\"\"", ""), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testQuoteAfterWhitespace1() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)" \"\"");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(1, "\"\"", ""), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testQuoteAfterWhitespace2() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)" \"b\"");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(1, "\"b\"", "b"), (Object)tokenizer.next());
        this.assertDone((Tokenizer)tokenizer);
    }

    public void testIndex() throws Exception {
        TokenizerImpl tokenizer = new TokenizerImpl((CharSequence)"a b");
        TokenizerTestCase.assertEquals((int)0, (int)tokenizer.getIndex());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a"), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((int)1, (int)tokenizer.getIndex());
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(1, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((int)2, (int)tokenizer.getIndex());
        tokenizer.pushBack(1);
        TokenizerTestCase.assertEquals((int)1, (int)tokenizer.getIndex());
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(1, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((int)2, (int)tokenizer.getIndex());
    }
}

