/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java;

import com.dokany.java.DokanyFileSystem;
import com.dokany.java.DokanyOperationsProxy;
import com.dokany.java.NativeMethods;
import com.dokany.java.constants.MountError;
import com.dokany.java.structure.DeviceOptions;
import com.sun.jna.WString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DokanyDriver {
    private static final Logger LOG = LoggerFactory.getLogger(DokanyDriver.class);
    private final DeviceOptions deviceOptions;
    private final DokanyFileSystem fileSystem;

    public DokanyDriver(DeviceOptions deviceOptions, DokanyFileSystem fileSystem) {
        this.deviceOptions = deviceOptions;
        this.fileSystem = fileSystem;
        LOG.info("Dokany version: {}", (Object)this.getVersion());
        LOG.info("Dokany driver version: {}", (Object)this.getDriverVersion());
    }

    public long getDriverVersion() {
        return NativeMethods.DokanDriverVersion();
    }

    public long getVersion() {
        return NativeMethods.DokanVersion();
    }

    public DokanyFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void start() {
        try {
            int mountStatus = NativeMethods.DokanMain(this.deviceOptions, new DokanyOperationsProxy(this.fileSystem));
            if (mountStatus < 0) {
                throw new IllegalStateException(MountError.fromInt(mountStatus).getDescription());
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    DokanyDriver.this.shutdown();
                }
            });
        }
        catch (Throwable t) {
            LOG.warn("Error mounting", t);
            throw t;
        }
    }

    public void shutdown() {
        DokanyDriver.stop(this.deviceOptions.MountPoint.toString());
    }

    public static void stop(String mountPoint) {
        LOG.info("Unmount and shutdown: {}", (Object)mountPoint);
        NativeMethods.DokanUnmount(mountPoint.charAt(0));
        NativeMethods.DokanRemoveMountPoint(new WString(mountPoint));
    }
}

