/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java;

import com.dokany.java.DokanyFileSystem;
import com.dokany.java.DokanyOperations;
import com.dokany.java.NativeMethods;
import com.dokany.java.structure.DokanyFileInfo;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.IntByReference;

final class DokanyOperationsProxy
extends DokanyOperations {
    private final DokanyFileSystem fileSystem;

    DokanyOperationsProxy(DokanyFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.ZwCreateFile = new ZwCreateFileProxy();
        this.CloseFile = fileSystem::closeFile;
        this.Cleanup = fileSystem::cleanup;
        this.ReadFile = fileSystem::readFile;
        this.WriteFile = fileSystem::writeFile;
        this.FlushFileBuffers = fileSystem::flushFileBuffers;
        this.GetFileInformation = fileSystem::getFileInformation;
        this.GetVolumeInformation = fileSystem::getVolumeInformation;
        this.GetDiskFreeSpace = fileSystem::getDiskFreeSpace;
        this.FindFiles = fileSystem::findFiles;
        this.FindFilesWithPattern = fileSystem::findFilesWithPattern;
        this.SetFileAttributes = fileSystem::setFileAttributes;
        this.SetFileTime = fileSystem::setFileTime;
        this.DeleteFile = fileSystem::deleteFile;
        this.DeleteDirectory = fileSystem::deleteDirectory;
        this.MoveFile = fileSystem::moveFile;
        this.SetEndOfFile = fileSystem::setEndOfFile;
        this.SetAllocationSize = fileSystem::setAllocationSize;
        this.LockFile = null;
        this.UnlockFile = null;
        this.Mounted = fileSystem::mounted;
        this.Unmounted = fileSystem::unmounted;
        this.GetFileSecurity = null;
        this.SetFileSecurity = null;
        this.FindStreams = null;
    }

    class ZwCreateFileProxy
    implements DokanyOperations.ZwCreateFile {
        ZwCreateFileProxy() {
        }

        @Override
        public long callback(WString rawPath, WinBase.SECURITY_ATTRIBUTES securityContext, int rawDesiredAccess, int rawFileAttributes, int rawShareAccess, int rawCreateDisposition, int rawCreateOptions, DokanyFileInfo dokanyFileInfo) {
            IntByReference createDisposition = new IntByReference();
            IntByReference desiredAccess = new IntByReference();
            IntByReference fileAttributeFlags = new IntByReference();
            NativeMethods.DokanMapKernelToUserCreateFileFlags(rawDesiredAccess, rawFileAttributes, rawCreateOptions, rawCreateDisposition, desiredAccess, fileAttributeFlags, createDisposition);
            return DokanyOperationsProxy.this.fileSystem.zwCreateFile(rawPath, securityContext, desiredAccess.getValue(), fileAttributeFlags.getValue(), rawShareAccess, createDisposition.getValue(), rawCreateOptions, dokanyFileInfo);
        }
    }
}

