/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java;

import com.dokany.java.DokanyException;
import com.dokany.java.constants.EnumInteger;
import com.dokany.java.constants.ErrorCode;
import com.dokany.java.constants.NtStatus;
import com.dokany.java.structure.DokanyFileInfo;
import com.dokany.java.structure.EnumIntegerSet;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DokanyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DokanyUtils.class);
    public static String UNIX_SEPARATOR = FilenameUtils.separatorsToUnix((String)File.separator);

    private DokanyUtils() {
    }

    public static String trimTailSeparator(String str) {
        return str.endsWith(UNIX_SEPARATOR) ? str.substring(0, str.length() - 1) : str;
    }

    public static String trimFrontSeparator(String str) {
        return str.startsWith(UNIX_SEPARATOR) ? str.substring(1, str.length()) : str;
    }

    public static Path getPath(String path) {
        return Paths.get(path, new String[0]);
    }

    public static File toFile(String path) {
        return DokanyUtils.getPath(path).toFile();
    }

    public static String normalize(String path) {
        int lastSeparator;
        String normalizedPath = FilenameUtils.normalize((String)path, (boolean)true);
        if (new File(normalizedPath).isDirectory() && ((lastSeparator = DokanyUtils.indexOfLastSeparator(normalizedPath)) == -1 || lastSeparator != normalizedPath.length() - 1)) {
            normalizedPath = normalizedPath + UNIX_SEPARATOR;
        }
        return normalizedPath;
    }

    public static int indexOfLastSeparator(String normalizedPath) {
        return FilenameUtils.indexOfLastSeparator((String)normalizedPath);
    }

    public static String normalize(WString path) {
        return DokanyUtils.normalize(path.toString());
    }

    public static String normalize(Path path) {
        return DokanyUtils.normalize(path.toString());
    }

    static String getFileName(String fileName) {
        return FilenameUtils.getBaseName((String)fileName);
    }

    static String getExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }

    public static String toShortName(Path path) {
        String pathAsStr = path.toString();
        String base = DokanyUtils.trimStrToSize(DokanyUtils.getFileName(pathAsStr), 8);
        LOG.trace("base: {}", (Object)base);
        String ext = DokanyUtils.trimStrToSize(DokanyUtils.getExtension(pathAsStr), 3);
        if (ext.length() > 0) {
            ext = "." + ext;
        }
        LOG.trace("ext: {}", (Object)ext);
        return base + ext;
    }

    public static String trimStrToSize(String str, int len) {
        return str.substring(0, Math.min(str.length(), len));
    }

    public static long exceptionToErrorCode(Throwable t) {
        return DokanyUtils.exceptionToErrorCode(t, NtStatus.UNSUCCESSFUL.getMask());
    }

    public static long exceptionToErrorCode(Throwable t, long defaultCode) {
        LOG.warn(t.getMessage(), t);
        if (t instanceof DokanyException) {
            return ((DokanyException)t).getValue();
        }
        if (t instanceof FileNotFoundException) {
            return ErrorCode.ERROR_FILE_NOT_FOUND.getMask();
        }
        if (t instanceof FileAlreadyExistsException) {
            return ErrorCode.ERROR_ALREADY_EXISTS.getMask();
        }
        return defaultCode;
    }

    public static FileTime toFileTime(WinBase.FILETIME time) {
        return FileTime.from(time.toDate().toInstant());
    }

    public static WinBase.FILETIME toFILETIME(FileTime time) {
        return DokanyUtils.getTime(time.toMillis());
    }

    public static WinBase.FILETIME getTime(Date date) {
        return new WinBase.FILETIME(date);
    }

    public static WinBase.FILETIME getTime(long time) {
        return DokanyUtils.getTime(new Date(time));
    }

    public static WinBase.FILETIME getCurrentTime() {
        return DokanyUtils.getTime(new Date());
    }

    public static WinNT.LARGE_INTEGER getLargeInt(long val, int high, int low) {
        WinNT.LARGE_INTEGER largeInt = null;
        if (val != 0L && (high == 0 || low == 0)) {
            largeInt = new WinNT.LARGE_INTEGER(val);
        }
        return largeInt;
    }

    public static BasicFileAttributeView getBasicAttributes(String path) {
        return DokanyUtils.getBasicAttributes(DokanyUtils.getPath(path));
    }

    public static BasicFileAttributeView getBasicAttributes(Path path) {
        return Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
    }

    public static <T extends Enum<T>> EnumIntegerSet<T> enumSetFromInt(int value, T[] allEnumValues) {
        EnumIntegerSet<T> elements = new EnumIntegerSet<T>(((Enum)allEnumValues[0]).getDeclaringClass());
        int remainingValues = value;
        for (T current : allEnumValues) {
            int mask = ((EnumInteger)current).getMask();
            if ((remainingValues & mask) != mask) continue;
            elements.add(current);
            remainingValues -= mask;
        }
        return elements;
    }

    public static <T extends EnumInteger> T enumFromInt(int value, T[] enumValues) {
        for (T current : enumValues) {
            if (value != current.getMask()) continue;
            return current;
        }
        throw new IllegalArgumentException("Invalid int value: " + value);
    }

    public static void setDeleteStatus(File fileOrDirectory, DokanyFileInfo dokanyFileInfo) {
        boolean canDelete = fileOrDirectory.renameTo(fileOrDirectory);
        if (canDelete) {
            dokanyFileInfo.DeleteOnClose = 1;
        }
    }

    public static String wStrToStr(WString wStr) {
        return Objects.nonNull(wStr) ? wStr.toString() : null;
    }
}

