/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java.structure;

import com.dokany.java.DokanyUtils;
import com.dokany.java.constants.FileAttribute;
import com.dokany.java.structure.EnumIntegerSet;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class ByHandleFileInfo
extends Structure
implements Structure.ByReference {
    AtomicLong counter = new AtomicLong();
    String filePath;
    long fileIndex;
    long fileSize;
    public int nFileIndexHigh;
    public int nFileIndexLow;
    public int dwFileAttributes;
    public WinBase.FILETIME ftCreationTime;
    public WinBase.FILETIME ftLastAccessTime;
    public WinBase.FILETIME ftLastWriteTime;
    public int nFileSizeHigh;
    public int nFileSizeLow;
    public int dwVolumeSerialNumber;
    public int dwNumberOfLinks = 1;

    public ByHandleFileInfo(WinBase.FILETIME creationTime, WinBase.FILETIME lastAccessTime, WinBase.FILETIME lastWriteTime) {
        this.setTimes(creationTime, lastAccessTime, lastWriteTime);
    }

    public ByHandleFileInfo(long creationTime, long lastAccessTime, long lastWriteTime) {
        this.setTimes(creationTime, lastAccessTime, lastWriteTime);
    }

    public ByHandleFileInfo() {
        this(null, null, null);
    }

    public void copyTo(ByHandleFileInfo infoToReceive) {
        if (Objects.isNull((Object)infoToReceive)) {
            throw new IllegalStateException("infoToReceive cannot be null");
        }
        infoToReceive.filePath = this.filePath;
        infoToReceive.setSize(this.fileSize, this.nFileSizeHigh, this.nFileSizeLow);
        infoToReceive.setIndex(this.fileIndex, this.nFileIndexHigh, this.nFileIndexLow);
        infoToReceive.dwFileAttributes = this.dwFileAttributes;
        infoToReceive.setTimes(this.ftCreationTime, this.ftLastAccessTime, this.ftLastWriteTime);
        infoToReceive.dwNumberOfLinks = this.dwNumberOfLinks;
        infoToReceive.dwVolumeSerialNumber = this.dwVolumeSerialNumber;
    }

    public void setAttributes(EnumIntegerSet<FileAttribute> attributes) {
        this.dwFileAttributes = Objects.nonNull(attributes) ? attributes.toInt() : FileAttribute.NORMAL.getMask();
    }

    public void setTimes(long creationTime, long lastAccessTime, long lastWriteTime) {
        WinBase.FILETIME now = DokanyUtils.getCurrentTime();
        this.ftCreationTime = creationTime == 0L ? now : DokanyUtils.getTime(creationTime);
        this.ftLastAccessTime = lastAccessTime == 0L ? now : DokanyUtils.getTime(lastAccessTime);
        this.ftLastWriteTime = lastWriteTime == 0L ? now : DokanyUtils.getTime(lastWriteTime);
    }

    void setTimes(WinBase.FILETIME creationTime, WinBase.FILETIME lastAccessTime, WinBase.FILETIME lastWriteTime) {
        WinBase.FILETIME now = DokanyUtils.getCurrentTime();
        this.ftCreationTime = Objects.isNull(creationTime) ? now : creationTime;
        this.ftLastAccessTime = Objects.isNull(lastAccessTime) ? now : lastAccessTime;
        this.ftLastWriteTime = Objects.isNull(lastWriteTime) ? now : lastWriteTime;
    }

    public void setLastWriteTime(long lastWriteTime) {
        this.ftLastAccessTime = this.ftLastWriteTime = lastWriteTime == 0L ? DokanyUtils.getCurrentTime() : DokanyUtils.getTime(lastWriteTime);
    }

    public void setCreationTime(long creationTime) {
        this.ftCreationTime = creationTime == 0L ? DokanyUtils.getCurrentTime() : DokanyUtils.getTime(creationTime);
    }

    public void setSize(long sizeToSet) {
        this.setSize(sizeToSet, 0, 0);
    }

    final void setSize(long size, int sizeHigh, int sizeLow) {
        this.fileSize = size;
        WinNT.LARGE_INTEGER largeInt = DokanyUtils.getLargeInt(size, sizeHigh, sizeLow);
        this.nFileSizeHigh = size != 0L && sizeHigh == 0 ? largeInt.getHigh().intValue() : (int)size;
        this.nFileSizeLow = size != 0L && sizeLow == 0 ? largeInt.getLow().intValue() : (int)size;
    }

    public final long getSize() {
        return this.fileSize;
    }

    public void setIndex(long indexToSet) {
        if (indexToSet == 0L) {
            this.counter.getAndIncrement();
        }
        this.setIndex(indexToSet, 0, 0);
    }

    final void setIndex(long index, int indexHigh, int indexLow) {
        this.fileIndex = index;
        WinNT.LARGE_INTEGER largeInt = DokanyUtils.getLargeInt(index, indexHigh, indexLow);
        this.nFileIndexHigh = index != 0L && indexHigh == 0 ? largeInt.getHigh().intValue() : (int)index;
        this.nFileIndexLow = index != 0L && indexLow == 0 ? largeInt.getLow().intValue() : (int)index;
    }

    public List<String> getFieldOrder() {
        return ByHandleFileInfo.createFieldsOrder((String[])new String[]{"dwFileAttributes", "ftCreationTime", "ftLastAccessTime", "ftLastWriteTime", "dwVolumeSerialNumber", "nFileSizeHigh", "nFileSizeLow", "dwNumberOfLinks", "nFileIndexHigh", "nFileIndexLow"});
    }

    public String toString() {
        return "ByHandleFileInfo(counter=" + this.counter + ", filePath=" + this.filePath + ", fileIndex=" + this.fileIndex + ", fileSize=" + this.fileSize + ", nFileIndexHigh=" + this.nFileIndexHigh + ", nFileIndexLow=" + this.nFileIndexLow + ", dwFileAttributes=" + this.dwFileAttributes + ", ftCreationTime=" + this.ftCreationTime + ", ftLastAccessTime=" + this.ftLastAccessTime + ", ftLastWriteTime=" + this.ftLastWriteTime + ", nFileSizeHigh=" + this.nFileSizeHigh + ", nFileSizeLow=" + this.nFileSizeLow + ", dwVolumeSerialNumber=" + this.dwVolumeSerialNumber + ", dwNumberOfLinks=" + this.dwNumberOfLinks + ")";
    }
}

