/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java.structure;

import com.dokany.java.DokanyUtils;
import com.dokany.java.constants.FileAttribute;
import com.dokany.java.structure.ByHandleFileInfo;
import com.dokany.java.structure.EnumIntegerSet;
import com.sun.jna.platform.win32.WinBase;
import java.io.FileNotFoundException;
import java.util.Objects;

public class FullFileInfo
extends ByHandleFileInfo {
    private int dwReserved0 = 0;
    private int dwReserved1 = 0;

    public FullFileInfo(String path, long index, EnumIntegerSet<FileAttribute> attributes, int volumeSerialNumber) throws FileNotFoundException {
        this(path, index, attributes, volumeSerialNumber, null, null, null);
    }

    public FullFileInfo(String path, long index, EnumIntegerSet<FileAttribute> attributes, int volumeSerialNumber, WinBase.FILETIME creationTime, WinBase.FILETIME lastAccessTime, WinBase.FILETIME lastWriteTime) throws FileNotFoundException {
        super(creationTime, lastAccessTime, lastWriteTime);
        this.filePath = Objects.requireNonNull(path);
        this.setIndex(index);
        this.setAttributes(attributes);
        this.dwVolumeSerialNumber = volumeSerialNumber;
    }

    public ByHandleFileInfo toByHandleFileInfo() {
        return this;
    }

    public WinBase.WIN32_FIND_DATA toWin32FindData() {
        char[] cFileName = DokanyUtils.trimFrontSeparator(DokanyUtils.trimStrToSize(this.filePath, 260)).toCharArray();
        char[] cAlternateFileName = new char[14];
        return new WinBase.WIN32_FIND_DATA(this.dwFileAttributes, this.ftCreationTime, this.ftLastAccessTime, this.ftLastWriteTime, this.nFileSizeHigh, this.nFileSizeLow, this.dwReserved0, this.dwReserved1, cFileName, cAlternateFileName);
    }

    @Override
    public String toString() {
        return "FullFileInfo(dwReserved0=" + this.dwReserved0 + ", dwReserved1=" + this.dwReserved1 + ")";
    }
}

