/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany;

import com.dokany.java.DokanyDriver;
import com.dokany.java.constants.FileSystemFeature;
import com.dokany.java.constants.MountOption;
import com.dokany.java.structure.DeviceOptions;
import com.dokany.java.structure.EnumIntegerSet;
import com.dokany.java.structure.VolumeInformation;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cryptomator.frontend.dokany.Mount;
import org.cryptomator.frontend.dokany.ReadWriteAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MountFactory.class);
    private static final int MOUNT_TIMEOUT_MS = 5000;
    private static final short THREAD_COUNT = 1;
    private static final EnumIntegerSet<MountOption> MOUNT_OPTIONS = new EnumIntegerSet((Enum)MountOption.REMOVABLE_DRIVE, (Enum[])new MountOption[]{MountOption.CURRENT_SESSION});
    private static final EnumIntegerSet<FileSystemFeature> FILE_SYSTEM_FEATURES = new EnumIntegerSet((Enum)FileSystemFeature.CASE_PRESERVED_NAMES, (Enum[])new FileSystemFeature[]{FileSystemFeature.CASE_SENSITIVE_SEARCH, FileSystemFeature.UNICODE_ON_DISK});
    private static final String UNC_NAME = "";
    private static final int TIMEOUT = 10000;
    private static final int ALLOC_UNIT_SIZE = 4096;
    private static final int SECTOR_SIZE = 4096;
    private final ExecutorService executorService;

    public MountFactory(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Mount mount(Path fileSystemRoot, char driveLetter, String volumeName, String fileSystemName) {
        Preconditions.checkArgument((boolean)CharMatcher.inRange((char)'B', (char)'Z').matches(driveLetter), (Object)"Invalid drive letter, expecting B-Z.");
        String mountPoint = driveLetter + ":\\";
        DeviceOptions deviceOptions = new DeviceOptions(mountPoint, 1, MOUNT_OPTIONS, UNC_NAME, 10000L, 4096L, 4096L);
        VolumeInformation volumeInfo = new VolumeInformation(256, volumeName, -1737075662, fileSystemName, FILE_SYSTEM_FEATURES);
        CompletableFuture mountDidSucceed = new CompletableFuture();
        ReadWriteAdapter dokanyFs = new ReadWriteAdapter(fileSystemRoot, volumeInfo, mountDidSucceed);
        DokanyDriver dokanyDriver = new DokanyDriver(deviceOptions, dokanyFs);
        LOG.debug("Mounting on drive {}: ...", (Object)Character.valueOf(driveLetter));
        Mount mount = new Mount(this.executorService, driveLetter, dokanyDriver);
        try {
            mountDidSucceed.get(5000L, TimeUnit.MILLISECONDS);
            LOG.debug("Mounted drive {}: successfully.", (Object)Character.valueOf(driveLetter));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.error("Mounting failed.", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.warn("Mounting timed out.");
        }
        return mount;
    }

    public static boolean isApplicable() {
        return System.getProperty("os.name").toLowerCase().contains("windows") && Files.exists(Paths.get("C:\\Windows\\System32\\drivers\\dokan1.sys", new String[0]), new LinkOption[0]);
    }
}

