/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany;

import com.google.common.base.MoreObjects;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.cryptomator.frontend.dokany.OpenHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFile
extends OpenHandle {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFile.class);
    private static final int BUFFER_SIZE = 4096;
    private final FileChannel channel;

    public OpenFile(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        super(path);
        this.channel = FileChannel.open(path, options, attrs);
    }

    public synchronized int read(Pointer buf, long num, long offset) throws IOException {
        int read;
        long size = this.channel.size();
        if (offset >= size) {
            return 0;
        }
        ByteBuffer bb = ByteBuffer.allocate(4096);
        long pos = 0L;
        this.channel.position(offset);
        do {
            long remaining;
            if ((read = this.readNext(bb, remaining = num - pos)) == -1) {
                return (int)pos;
            }
            LOG.trace("Reading {}-{} ({}-{})", new Object[]{offset + pos, offset + pos + (long)read, offset, offset + num});
            buf.write(pos, bb.array(), 0, read);
        } while ((pos += (long)read) < num);
        return (int)pos;
    }

    public synchronized int write(Pointer buf, long num, long offset) throws IOException {
        int len;
        ByteBuffer bb = ByteBuffer.allocate(4096);
        long written = 0L;
        this.channel.position(offset);
        do {
            long remaining = num - written;
            bb.clear();
            len = (int)Math.min(remaining, (long)bb.capacity());
            buf.read(written, bb.array(), 0, len);
            bb.limit(len);
            this.channel.write(bb);
        } while ((written += (long)len) < num);
        return (int)written;
    }

    private int readNext(ByteBuffer readBuf, long num) throws IOException {
        readBuf.clear();
        readBuf.limit((int)Math.min((long)readBuf.capacity(), num));
        return this.channel.read(readBuf);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public void flush() throws IOException {
        this.channel.force(false);
    }

    public void truncate(long size) throws IOException {
        this.channel.truncate(size);
    }

    public boolean canBeDeleted() {
        try {
            FileLock lock = this.channel.tryLock();
            if (lock != null) {
                lock.release();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(OpenFile.class).add("path", (Object)this.path).add("channel", (Object)this.channel).toString();
    }
}

