/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany;

import com.dokany.java.DokanyFileSystem;
import com.dokany.java.DokanyOperations;
import com.dokany.java.DokanyUtils;
import com.dokany.java.constants.CreateOptions;
import com.dokany.java.constants.CreationDisposition;
import com.dokany.java.constants.ErrorCode;
import com.dokany.java.constants.NtStatus;
import com.dokany.java.structure.ByHandleFileInfo;
import com.dokany.java.structure.DokanyFileInfo;
import com.dokany.java.structure.EnumIntegerSet;
import com.dokany.java.structure.FullFileInfo;
import com.dokany.java.structure.VolumeInformation;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Sets;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.cryptomator.frontend.dokany.FileUtil;
import org.cryptomator.frontend.dokany.OpenFile;
import org.cryptomator.frontend.dokany.OpenHandle;
import org.cryptomator.frontend.dokany.OpenHandleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteAdapter
implements DokanyFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteAdapter.class);
    private final Path root;
    private final VolumeInformation volumeInformation;
    private final CompletableFuture didMount;
    private final OpenHandleFactory fac;
    private final FileStore fileStore;

    public ReadWriteAdapter(Path root, VolumeInformation volumeInformation, CompletableFuture<?> didMount) {
        this.root = root;
        this.volumeInformation = volumeInformation;
        this.didMount = didMount;
        this.fac = new OpenHandleFactory();
        try {
            this.fileStore = Files.getFileStore(root);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long zwCreateFile(WString rawPath, WinBase.SECURITY_ATTRIBUTES securityContext, int rawDesiredAccess, int rawFileAttributes, int rawShareAccess, int rawCreateDisposition, int rawCreateOptions, DokanyFileInfo dokanyFileInfo) {
        HashSet openOptions;
        CreationDisposition creationDisposition;
        Path path;
        block23: {
            block22: {
                Optional<Object> attr;
                if (this.isSkipFile(rawPath)) {
                    return ErrorCode.SUCCESS.getMask();
                }
                path = this.getRootedPath(rawPath);
                creationDisposition = CreationDisposition.fromInt(rawCreateDisposition);
                LOG.debug("zwCreateFile() is called for {} with CreationDisposition {}.", (Object)path.toString(), (Object)creationDisposition.name());
                try {
                    attr = Optional.of(Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS));
                }
                catch (IOException e) {
                    attr = Optional.empty();
                }
                EnumIntegerSet createOptions = DokanyUtils.enumSetFromInt((int)rawCreateOptions, (Enum[])CreateOptions.values());
                if (attr.isPresent() && ((BasicFileAttributes)attr.get()).isDirectory()) {
                    if ((rawCreateOptions & CreateOptions.FILE_NON_DIRECTORY_FILE.getMask()) == 0) {
                        dokanyFileInfo.IsDirectory = 1;
                    } else {
                        LOG.trace("Ressource {} is a Directory and cannot be opened as a file.");
                        return 3221225658L;
                    }
                }
                if (dokanyFileInfo.isDirectory()) {
                    return this.createDirectory(path, creationDisposition, rawFileAttributes, dokanyFileInfo);
                }
                openOptions = Sets.newHashSet();
                openOptions.add(StandardOpenOption.READ);
                openOptions.add(StandardOpenOption.WRITE);
                if (!attr.isPresent()) break block22;
                switch (creationDisposition) {
                    case CREATE_NEW: {
                        break block23;
                    }
                    case CREATE_ALWAYS: {
                        openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                        break block23;
                    }
                    case OPEN_EXISTING: {
                        break block23;
                    }
                    case OPEN_ALWAYS: {
                        openOptions.add(StandardOpenOption.CREATE);
                        break block23;
                    }
                    case TRUNCATE_EXISTING: {
                        openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                        break block23;
                    }
                    default: {
                        throw new IllegalStateException("Unknown createDispostion attribute: " + creationDisposition.name());
                    }
                }
            }
            switch (creationDisposition) {
                case CREATE_NEW: {
                    openOptions.add(StandardOpenOption.CREATE_NEW);
                    break;
                }
                case CREATE_ALWAYS: {
                    openOptions.add(StandardOpenOption.CREATE);
                    break;
                }
                case OPEN_EXISTING: {
                    break;
                }
                case OPEN_ALWAYS: {
                    openOptions.add(StandardOpenOption.CREATE);
                    break;
                }
                case TRUNCATE_EXISTING: {
                    openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown createDispostion attribute: " + creationDisposition.name());
                }
            }
        }
        if (dokanyFileInfo.writeToEndOfFile()) {
            openOptions.add(StandardOpenOption.APPEND);
        }
        return this.createFile(path, creationDisposition, openOptions, rawFileAttributes, dokanyFileInfo);
    }

    private long createDirectory(Path path, CreationDisposition creationDisposition, int rawFileAttributes, DokanyFileInfo dokanyFileInfo) {
        LOG.trace("Try to open {} as Directory.");
        int mask = creationDisposition.getMask();
        if (mask == CreationDisposition.CREATE_NEW.getMask() || mask == CreationDisposition.OPEN_ALWAYS.getMask()) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
                LOG.trace("Directory {} successful created ", (Object)path.toString());
            }
            catch (FileAlreadyExistsException e) {
                if (mask == CreationDisposition.CREATE_NEW.getMask()) {
                    LOG.trace("Directory {} already exists.", (Object)path.toString());
                    return ErrorCode.ERROR_ALREADY_EXISTS.getMask();
                }
            }
            catch (IOException e) {
                LOG.info("zwCreateFile(): IO error occured during the creation of {}.", (Object)path.toString());
                LOG.debug("zwCreateFile(): ", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            LOG.trace("Attempt to open file {} as a directory.", (Object)path.toString());
            return 3221225658L;
        }
        this.setFileAttributes(path, rawFileAttributes);
        dokanyFileInfo.Context = this.fac.openDir(path);
        LOG.trace("({}) {} opened successful with handle {}.", new Object[]{dokanyFileInfo.Context, path.toString(), dokanyFileInfo.Context});
        if (mask == CreationDisposition.OPEN_ALWAYS.getMask()) {
            return ErrorCode.OBJECT_NAME_COLLISION.getMask();
        }
        return ErrorCode.SUCCESS.getMask();
    }

    private long createFile(Path path, CreationDisposition creationDisposition, Set<OpenOption> openOptions, int rawFileAttributes, DokanyFileInfo dokanyFileInfo) {
        LOG.trace("Try to open {} as File.");
        int mask = creationDisposition.getMask();
        DosFileAttributes attr = null;
        try {
            attr = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            LOG.trace("Could not read file attributes.");
        }
        if (attr != null && (mask == CreationDisposition.TRUNCATE_EXISTING.getMask() || mask == CreationDisposition.CREATE_ALWAYS.getMask()) && ((rawFileAttributes & com.dokany.java.constants.FileAttribute.HIDDEN.getMask()) == 0 && attr.isHidden() || (rawFileAttributes & com.dokany.java.constants.FileAttribute.SYSTEM.getMask()) == 0 && attr.isSystem())) {
            LOG.trace("{} is hidden or system file. Unable to overwrite.", (Object)path.toString());
            return NtStatus.ACCESS_DENIED.getMask();
        }
        if ((attr != null && attr.isReadOnly() || (rawFileAttributes & com.dokany.java.constants.FileAttribute.READONLY.getMask()) != 0) && dokanyFileInfo.DeleteOnClose != 0) {
            LOG.trace("{} is readonly. Unable to overwrite.", (Object)path.toString());
            return NtStatus.CANNOT_DELETE.getMask();
        }
        try {
            dokanyFileInfo.Context = this.fac.openFile(path, openOptions, new FileAttribute[0]);
            LOG.trace("({}) {} opened successful with handle {}.", new Object[]{dokanyFileInfo.Context, path.toString(), dokanyFileInfo.Context});
            this.setFileAttributes(path, rawFileAttributes);
            if (attr != null && (mask == CreationDisposition.OPEN_ALWAYS.getMask() || mask == CreationDisposition.CREATE_ALWAYS.getMask())) {
                return NtStatus.OBJECT_NAME_COLLISION.getMask();
            }
            LOG.trace("({}) {} opened successful with handle {}.", new Object[]{dokanyFileInfo.Context, path.toString(), dokanyFileInfo.Context});
            return ErrorCode.SUCCESS.getMask();
        }
        catch (FileAlreadyExistsException e) {
            LOG.trace("Unable to open {}.", (Object)path.toString());
            return NtStatus.OBJECT_NAME_EXISTS.getMask();
        }
        catch (NoSuchFileException e) {
            LOG.trace("{} not found.", (Object)path.toString());
            return NtStatus.OBJECT_NAME_NOT_FOUND.getMask();
        }
        catch (IOException e) {
            LOG.info("zwCreateFile(): IO error occurred during creation of {}.", (Object)path.toString());
            LOG.debug("zwCreateFile(): ", (Throwable)e);
            return NtStatus.UNSUCCESSFUL.getMask();
        }
    }

    @Override
    public void cleanup(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        if (this.isSkipFile(rawPath)) {
            return;
        }
        Path path = this.getRootedPath(rawPath);
        LOG.debug("({}) cleanup() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("cleanup(): Invalid handle to {}.", (Object)path.toString());
        } else {
            try {
                this.fac.close(dokanyFileInfo.Context);
                if (dokanyFileInfo.deleteOnClose()) {
                    try {
                        Files.delete(path);
                        LOG.trace("({}) {} successful deleted.", (Object)dokanyFileInfo.Context, (Object)path.toString());
                    }
                    catch (DirectoryNotEmptyException e) {
                        LOG.trace("({}) Directory {} not empty.", (Object)dokanyFileInfo.Context, (Object)path.toString());
                    }
                    catch (IOException e) {
                        LOG.info("({}) cleanup(): IO error during deletion of {} ", new Object[]{dokanyFileInfo.Context, path.toString(), e});
                        LOG.debug("cleanup(): ", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("({}) cleanup(): Unable to close handle to {}", new Object[]{dokanyFileInfo.Context, path.toString(), e});
                LOG.debug("cleanup(): ", (Throwable)e);
            }
        }
    }

    @Override
    public void closeFile(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        if (this.isSkipFile(rawPath)) {
            return;
        }
        Path p = this.getRootedPath(rawPath);
        LOG.debug("({}) closeFile() is called for {}.", (Object)dokanyFileInfo.Context, (Object)p.toString());
        if (this.fac.exists(dokanyFileInfo.Context)) {
            LOG.info("({}) Resource {} was not cleauped. Closing handle now.", (Object)dokanyFileInfo.Context, (Object)p.toString());
            try {
                this.fac.close(dokanyFileInfo.Context);
            }
            catch (IOException e) {
                LOG.warn("({}) closeFile(): Unable to close handle to resource {}. To close it please restart the adapter.", (Object)dokanyFileInfo.Context, (Object)p.toString());
                LOG.debug("closeFile():", (Throwable)e);
            }
        }
        dokanyFileInfo.Context = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readFile(WString rawPath, Pointer rawBuffer, int rawBufferLength, IntByReference rawReadLength, long rawOffset, DokanyFileInfo dokanyFileInfo) {
        if (this.isSkipFile(rawPath)) {
            return ErrorCode.SUCCESS.getMask();
        }
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) readFile() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("readFile(): Invalid handle to {} ", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        if (dokanyFileInfo.isDirectory()) {
            LOG.trace("({}) {} is a directory. Unable to read Data from it.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return NtStatus.ACCESS_DENIED.getMask();
        }
        long handleID = dokanyFileInfo.Context;
        boolean reopened = false;
        OpenFile handle = (OpenFile)this.fac.get(handleID);
        if (handle == null) {
            LOG.trace("({}) readFile(): Unable to find handle for {}. Try to reopen it.", (Object)handleID, (Object)this.getRootedPath(rawPath).toString());
            try {
                handleID = this.fac.openFile(path, Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);
                handle = (OpenFile)this.fac.get(handleID);
                LOG.trace("readFile(): Successful reopened {} with handle {}.", (Object)path.toString(), (Object)handleID);
                reopened = true;
            }
            catch (IOException e1) {
                LOG.debug("readFile(): Reopen of {} failed. Aborting.", (Object)path.toString());
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
        try {
            rawReadLength.setValue(handle.read(rawBuffer, rawBufferLength, rawOffset));
            LOG.trace("({}) Data successful read from {}.", (Object)handleID, (Object)path.toString());
            long e1 = ErrorCode.SUCCESS.getMask();
            return e1;
        }
        catch (IOException e) {
            LOG.info("({}) readFile(): IO error while reading file {}.", new Object[]{handleID, path.toString(), e});
            long l = ErrorCode.ERROR_READ_FAULT.getMask();
            return l;
        }
        finally {
            if (reopened) {
                try {
                    handle.close();
                    LOG.trace("({}) readFile(): Successful closed REOPENED file {}.", (Object)handleID, (Object)path.toString());
                }
                catch (IOException e) {
                    LOG.info("({}) readFile(): IO error while closing REOPENED file {}. File will be closed on exit.", (Object)handleID, (Object)path.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long writeFile(WString rawPath, Pointer rawBuffer, int rawNumberOfBytesToWrite, IntByReference rawNumberOfBytesWritten, long rawOffset, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) writeFile() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("writeFile(): Invalid handle to {}", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        if (dokanyFileInfo.isDirectory()) {
            LOG.trace("({}) {} is a directory. Unable to write Data to it.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return NtStatus.ACCESS_DENIED.getMask();
        }
        long handleID = dokanyFileInfo.Context;
        boolean reopened = false;
        OpenFile handle = (OpenFile)this.fac.get(handleID);
        if (handle == null) {
            LOG.trace("({}) writeFile(): Unable to find handle for {}. Try to reopen it.", (Object)handleID, (Object)this.getRootedPath(rawPath).toString());
            try {
                handleID = this.fac.openFile(path, Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);
                handle = (OpenFile)this.fac.get(handleID);
                LOG.trace("writeFile(): Successful reopened {} with handle {}.", (Object)path.toString(), (Object)handleID);
                reopened = true;
            }
            catch (IOException e1) {
                LOG.debug("writeFile(): Reopen of {} failed. Aborting.", (Object)path.toString());
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
        try {
            rawNumberOfBytesWritten.setValue(handle.write(rawBuffer, rawNumberOfBytesToWrite, rawOffset));
            LOG.trace("({}) Data successful written to {}.", (Object)handleID, (Object)path.toString());
            long e1 = ErrorCode.SUCCESS.getMask();
            return e1;
        }
        catch (IOException e) {
            LOG.info("({}) writeFile(): IO Error while writing to {} ", new Object[]{handleID, path.toString(), e});
            long l = ErrorCode.ERROR_WRITE_FAULT.getMask();
            return l;
        }
        finally {
            if (reopened) {
                try {
                    handle.close();
                    LOG.trace("({}) writeFile(): Successful closed REOPENED file {}.", (Object)handleID, (Object)path.toString());
                }
                catch (IOException e) {
                    LOG.info("({}) writeFile(): IO error while closing REOPENED file {}. File will be closed on exit.", (Object)handleID, (Object)path.toString());
                }
            }
        }
    }

    @Override
    public long flushFileBuffers(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.debug("({}) flushFileBuffers() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("flushFileBuffers(): Invalid handle to {}.", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        if (dokanyFileInfo.isDirectory()) {
            LOG.trace("({}) {} is a directory. Unable to write Data to it.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return NtStatus.ACCESS_DENIED.getMask();
        }
        OpenHandle handle = this.fac.get(dokanyFileInfo.Context);
        try {
            ((OpenFile)handle).flush();
        }
        catch (IOException e) {
            LOG.info("({}) flushFileBuffers(): IO Error while flushing to {}.", new Object[]{dokanyFileInfo.Context, path.toString(), e});
            LOG.debug("flushFileBuffers(): ", (Throwable)e);
            return ErrorCode.ERROR_WRITE_FAULT.getMask();
        }
        LOG.trace("Flushed successful to {} with handle {}.", (Object)path.toString(), (Object)dokanyFileInfo.Context);
        return ErrorCode.SUCCESS.getMask();
    }

    @Override
    public long getFileInformation(WString fileName, ByHandleFileInfo handleFileInfo, DokanyFileInfo dokanyFileInfo) {
        if (this.isSkipFile(fileName)) {
            return ErrorCode.SUCCESS.getMask();
        }
        Path path = this.getRootedPath(fileName);
        LOG.debug("({}) getFileInformation() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("getFileInformation(): Invalid handle to {}.", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        try {
            FullFileInfo data = this.getFileInfo(path);
            data.copyTo(handleFileInfo);
            LOG.trace("({}) File Information successful read from {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return ErrorCode.SUCCESS.getMask();
        }
        catch (NoSuchFileException e) {
            LOG.debug("({}) Resource {} not found.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return ErrorCode.ERROR_FILE_NOT_FOUND.getMask();
        }
        catch (IOException e) {
            LOG.info("({}) getFileInformation(): IO error occured in reading meta data from {}.", new Object[]{dokanyFileInfo.Context, path.toString(), e});
            LOG.debug("getFileInformation(): ", (Throwable)e);
            return NtStatus.UNSUCCESSFUL.getMask();
        }
    }

    private FullFileInfo getFileInfo(Path p) throws IOException {
        Path filename;
        DosFileAttributes attr = Files.readAttributes(p, DosFileAttributes.class, new LinkOption[0]);
        long index = 0L;
        if (attr.fileKey() != null) {
            index = (Long)attr.fileKey();
        }
        FullFileInfo data = new FullFileInfo((filename = p.getFileName()) != null ? filename.toString() : "", index, FileUtil.dosAttributesToEnumIntegerSet(attr), 0, DokanyUtils.getTime(attr.creationTime().toMillis()), DokanyUtils.getTime(attr.lastAccessTime().toMillis()), DokanyUtils.getTime(attr.lastModifiedTime().toMillis()));
        data.setSize(attr.size());
        return data;
    }

    @Override
    public long findFiles(WString rawPath, DokanyOperations.FillWin32FindData rawFillFindData, DokanyFileInfo dokanyFileInfo) {
        if (this.isSkipFile(rawPath)) {
            return ErrorCode.SUCCESS.getMask();
        }
        LOG.debug("({}) findFiles() is called for {}.", (Object)dokanyFileInfo.Context, (Object)this.getRootedPath(rawPath).toString());
        return this.findFilesWithPattern(rawPath, new WString("*"), rawFillFindData, dokanyFileInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long findFilesWithPattern(WString fileName, WString searchPattern, DokanyOperations.FillWin32FindData rawFillFindData, DokanyFileInfo dokanyFileInfo) {
        if (this.isSkipFile(fileName)) {
            return ErrorCode.SUCCESS.getMask();
        }
        Path path = this.getRootedPath(fileName);
        LOG.debug("({}) findFilesWithPattern() is called for {} with search pattern {}.", new Object[]{dokanyFileInfo.Context, path.toString(), searchPattern.toString()});
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("findFilesWithPattern(): Invalid handle to {}.", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        try (Stream<Path> stream = Files.list(path);){
            Stream<Path> filteredStream;
            if (searchPattern == null || searchPattern.toString().equals("*")) {
                filteredStream = stream;
            } else {
                PathMatcher matcher = path.getFileSystem().getPathMatcher("glob:" + searchPattern.toString());
                filteredStream = stream.map(Path::getFileName).filter(matcher::matches);
            }
            filteredStream.map(p -> {
                try {
                    return this.getFileInfo(path.resolve((Path)p)).toWin32FindData();
                }
                catch (IOException e) {
                    LOG.warn("({}) findFilesWithPatter(): IO error accessing {}.", (Object)dokanyFileInfo.Context, (Object)p.toString());
                    return null;
                }
            }).forEach(file -> {
                try {
                    if (file != null) {
                        LOG.trace("({}) findFilesWithPattern(): found file {}", (Object)dokanyFileInfo.Context, (Object)file.getFileName());
                        rawFillFindData.fillWin32FindData((WinBase.WIN32_FIND_DATA)file, dokanyFileInfo);
                    }
                }
                catch (Error e) {
                    LOG.error("({}) Error filling Win32FindData with file {}. Occurred error is {}", (Object)dokanyFileInfo.Context, (Object)file.getFileName());
                    LOG.error("(" + dokanyFileInfo.Context + ") findFilesWithPattern(): Stacktrace:", (Throwable)e);
                }
            });
            LOG.trace("({}) Successful searched content in {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            long l = ErrorCode.SUCCESS.getMask();
            return l;
        }
        catch (IOException e) {
            LOG.error("({}) findFilesWithPattern(): Unable to list content of directory {}. Error is {}", new Object[]{dokanyFileInfo.Context, path.toString(), e});
            return NtStatus.UNSUCCESSFUL.getMask();
        }
    }

    @Override
    public long setFileAttributes(WString rawPath, int rawAttributes, DokanyFileInfo dokanyFileInfo) {
        if (this.isSkipFile(rawPath)) {
            return ErrorCode.SUCCESS.getMask();
        }
        Path path = this.getRootedPath(rawPath);
        LOG.debug("({}) setFileAttributes() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("setFileAttribute(): Invalid handle to {}.", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        return this.setFileAttributes(path, rawAttributes);
    }

    private long setFileAttributes(Path path, int rawAttributes) {
        if (Files.notExists(path, new LinkOption[0])) {
            return ErrorCode.ERROR_FILE_NOT_FOUND.getMask();
        }
        DosFileAttributeView attrView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
        try {
            for (com.dokany.java.constants.FileAttribute attr : com.dokany.java.constants.FileAttribute.fromInt(rawAttributes)) {
                FileUtil.setAttribute(attrView, attr);
            }
        }
        catch (IOException e) {
            return ErrorCode.ERROR_WRITE_FAULT.getMask();
        }
        return ErrorCode.SUCCESS.getMask();
    }

    @Override
    public long setFileTime(WString rawPath, WinBase.FILETIME rawCreationTime, WinBase.FILETIME rawLastAccessTime, WinBase.FILETIME rawLastWriteTime, DokanyFileInfo dokanyFileInfo) {
        if (this.isSkipFile(rawPath)) {
            return ErrorCode.SUCCESS.getMask();
        }
        Path path = this.getRootedPath(rawPath);
        LOG.debug("({}) setFileTime() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("setFileTime(): Invalid handle to {}.", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        try {
            FileTime lastModifiedTime = FileTime.fromMillis(rawLastWriteTime.toDate().getTime());
            FileTime lastAccessTime = FileTime.fromMillis(rawLastWriteTime.toDate().getTime());
            FileTime createdTime = FileTime.fromMillis(rawLastWriteTime.toDate().getTime());
            Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).setTimes(lastModifiedTime, lastAccessTime, createdTime);
            LOG.trace("({}) Successful updated Filetime for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return ErrorCode.SUCCESS.getMask();
        }
        catch (NoSuchFileException e) {
            LOG.trace("({}) File {} not found.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return ErrorCode.ERROR_FILE_NOT_FOUND.getMask();
        }
        catch (IOException e) {
            LOG.info("({}) setFileTime(): IO error occurred accessing {}.", new Object[]{dokanyFileInfo.Context, path.toString(), e});
            LOG.debug("setFileTime(): ", (Throwable)e);
            return NtStatus.UNSUCCESSFUL.getMask();
        }
    }

    @Override
    public long deleteFile(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.debug("({}) deleteFile() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("deleteFile(): Invalid handle to {}.", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        if (dokanyFileInfo.isDirectory()) {
            LOG.warn("({}) {} is a directory. Unable to delete via deleteFile()", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return NtStatus.ACCESS_DENIED.getMask();
        }
        OpenHandle handle = this.fac.get(dokanyFileInfo.Context);
        if (Files.exists(path, new LinkOption[0])) {
            if (((OpenFile)handle).canBeDeleted()) {
                LOG.trace("({}) Deletion of {} possible.", (Object)dokanyFileInfo.Context, (Object)path.toString());
                return NtStatus.SUCCESS.getMask();
            }
            LOG.trace("({}) Deletion of {} not possible.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return NtStatus.CANNOT_DELETE.getMask();
        }
        LOG.trace("({}) {} not found.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        return NtStatus.OBJECT_NAME_NOT_FOUND.getMask();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long deleteDirectory(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.debug("({}) deleteDirectory() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("deleteDirectory(): Invalid handle to {}.", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        if (!dokanyFileInfo.isDirectory()) {
            LOG.warn("({}) {} is a file. Unable to delete via deleteDirectory()", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return NtStatus.ACCESS_DENIED.getMask();
        }
        try (DirectoryStream<Path> emptyCheck = Files.newDirectoryStream(path);){
            if (emptyCheck.iterator().hasNext()) {
                LOG.trace("({}) Deletion of {} not possible.", (Object)dokanyFileInfo.Context, (Object)path.toString());
                long l2 = NtStatus.DIRECTORY_NOT_EMPTY.getMask();
                return l2;
            }
            LOG.trace("({}) Deletion of {} possible.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            long l = ErrorCode.SUCCESS.getMask();
            return l;
        }
        catch (IOException e) {
            LOG.info("({}) deleteDirectory(): IO error occurred reading {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            LOG.debug("deleteDirectory(): ", (Throwable)e);
            return NtStatus.UNSUCCESSFUL.getMask();
        }
    }

    @Override
    public long moveFile(WString rawPath, WString rawNewFileName, boolean rawReplaceIfExisting, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        Path newPath = this.getRootedPath(rawNewFileName);
        LOG.debug("({}) moveFile() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("moveFile(): Invalid handle to {}.", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        try {
            if (rawReplaceIfExisting) {
                Files.move(path, newPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(path, newPath, new CopyOption[0]);
            }
            LOG.trace("({}) Successful moved resource {} to {}.", new Object[]{dokanyFileInfo.Context, path.toString(), newPath});
            return ErrorCode.SUCCESS.getMask();
        }
        catch (FileAlreadyExistsException e) {
            LOG.trace("({}) Ressource {} already exists at {}.", new Object[]{dokanyFileInfo.Context, path.toString(), newPath});
            return ErrorCode.ERROR_FILE_EXISTS.getMask();
        }
        catch (DirectoryNotEmptyException e) {
            LOG.trace("({}) Target directoy {} is not emtpy.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return NtStatus.DIRECTORY_NOT_EMPTY.getMask();
        }
        catch (IOException e) {
            LOG.info("({}) moveFile(): IO error occured while moving ressource {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            LOG.debug("moveFile(): ", (Throwable)e);
            return NtStatus.UNSUCCESSFUL.getMask();
        }
    }

    @Override
    public long setEndOfFile(WString rawPath, long rawByteOffset, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.debug("({}) setEndOfFile() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        if (dokanyFileInfo.Context == 0L) {
            LOG.info("setEndOfFile(): Invalid handle to {}.", (Object)path.toString());
            return NtStatus.UNSUCCESSFUL.getMask();
        }
        if (dokanyFileInfo.isDirectory()) {
            LOG.warn("({}) setEndOfFile(): {} is a directory. Unable to truncate.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return NtStatus.ACCESS_DENIED.getMask();
        }
        try {
            OpenHandle handle = this.fac.get(dokanyFileInfo.Context);
            ((OpenFile)handle).truncate(rawByteOffset);
            LOG.trace("({}) Successful truncated {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            return NtStatus.SUCCESS.getMask();
        }
        catch (IOException e) {
            LOG.info("({}) setEndOfFile(): IO error while truncating {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
            LOG.debug("setEndOfFile(): ", (Throwable)e);
            return NtStatus.UNSUCCESSFUL.getMask();
        }
    }

    @Override
    public long setAllocationSize(WString rawPath, long rawLength, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.debug("({}) setAllocationSize() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path.toString());
        return this.setEndOfFile(rawPath, rawLength, dokanyFileInfo);
    }

    @Override
    public long lockFile(WString rawPath, long rawByteOffset, long rawLength, DokanyFileInfo dokanyFileInfo) {
        return 0L;
    }

    @Override
    public long unlockFile(WString rawPath, long rawByteOffset, long rawLength, DokanyFileInfo dokanyFileInfo) {
        return 0L;
    }

    @Override
    public long getDiskFreeSpace(LongByReference freeBytesAvailable, LongByReference totalNumberOfBytes, LongByReference totalNumberOfFreeBytes, DokanyFileInfo dokanyFileInfo) {
        LOG.debug("getFreeDiskSpace() is called.");
        try {
            totalNumberOfBytes.setValue(this.fileStore.getTotalSpace());
            freeBytesAvailable.setValue(this.fileStore.getUsableSpace());
            totalNumberOfFreeBytes.setValue(this.fileStore.getUnallocatedSpace());
            return ErrorCode.SUCCESS.getMask();
        }
        catch (IOException e) {
            LOG.info("({}) getFreeDiskSpace(): Unable to detect disk space status.", (Object)dokanyFileInfo.Context, (Object)e);
            return NtStatus.UNSUCCESSFUL.getMask();
        }
    }

    @Override
    public long getVolumeInformation(Pointer rawVolumeNameBuffer, int rawVolumeNameSize, IntByReference rawVolumeSerialNumber, IntByReference rawMaximumComponentLength, IntByReference rawFileSystemFlags, Pointer rawFileSystemNameBuffer, int rawFileSystemNameSize, DokanyFileInfo dokanyFileInfo) {
        try {
            rawVolumeNameBuffer.setWideString(0L, DokanyUtils.trimStrToSize(this.volumeInformation.getName(), rawVolumeNameSize));
            rawVolumeSerialNumber.setValue(this.volumeInformation.getSerialNumber());
            rawMaximumComponentLength.setValue(this.volumeInformation.getMaxComponentLength());
            rawFileSystemFlags.setValue(this.volumeInformation.getFileSystemFeatures().toInt());
            rawFileSystemNameBuffer.setWideString(0L, DokanyUtils.trimStrToSize(this.volumeInformation.getFileSystemName(), rawFileSystemNameSize));
            return ErrorCode.SUCCESS.getMask();
        }
        catch (Throwable t) {
            return DokanyUtils.exceptionToErrorCode(t);
        }
    }

    @Override
    public long mounted(DokanyFileInfo dokanyFileInfo) {
        LOG.debug("mounted() is called.");
        this.didMount.complete(null);
        return 0L;
    }

    @Override
    public long unmounted(DokanyFileInfo dokanyFileInfo) {
        LOG.debug("unmounted() is called.");
        return 0L;
    }

    @Override
    public long getFileSecurity(WString rawPath, int rawSecurityInformation, Pointer rawSecurityDescriptor, int rawSecurityDescriptorLength, IntByReference rawSecurityDescriptorLengthNeeded, DokanyFileInfo dokanyFileInfo) {
        return 0L;
    }

    @Override
    public long setFileSecurity(WString rawPath, int rawSecurityInformation, Pointer rawSecurityDescriptor, int rawSecurityDescriptorLength, DokanyFileInfo dokanyFileInfo) {
        return 0L;
    }

    @Override
    public void fillWin32FindData(WinBase.WIN32_FIND_DATA rawFillFindData, DokanyFileInfo dokanyFileInfo) {
    }

    @Override
    public long findStreams(WString rawPath, DokanyOperations.FillWin32FindStreamData rawFillFindData, DokanyFileInfo dokanyFileInfo) {
        return 0L;
    }

    private Path getRootedPath(WString rawPath) {
        String unixPath = rawPath.toString().replace('\\', '/');
        String relativeUnixPath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)unixPath);
        return this.root.resolve(relativeUnixPath);
    }

    private boolean isSkipFile(WString filepath) {
        String pathLowerCase = filepath.toString().toLowerCase();
        if (pathLowerCase.endsWith("desktop.ini") || pathLowerCase.endsWith("autorun.inf")) {
            LOG.trace("Skipping file: " + this.getRootedPath(filepath));
            return true;
        }
        return false;
    }
}

