/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.cthing.versionparser.Version;

public class VersionRange
implements Comparable<VersionRange> {
    @Nullable
    private final Version minVersion;
    @Nullable
    private final Version maxVersion;
    private final boolean minIncluded;
    private final boolean maxIncluded;

    public VersionRange(@Nullable Version minVersion, @Nullable Version maxVersion, boolean minIncluded, boolean maxIncluded) {
        if (minVersion != null && maxVersion != null && minVersion.compareTo(maxVersion) > 0) {
            throw new IllegalArgumentException("Minimum version must be less than maximum version");
        }
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.minIncluded = minIncluded;
        this.maxIncluded = maxIncluded;
    }

    public VersionRange(Version version) {
        this(version, version, true, true);
    }

    @Nullable
    public Version getMinVersion() {
        return this.minVersion;
    }

    @Nullable
    public Version getMaxVersion() {
        return this.maxVersion;
    }

    public boolean isMinIncluded() {
        return this.minIncluded;
    }

    public boolean isMaxIncluded() {
        return this.maxIncluded;
    }

    boolean isAny() {
        return this.minVersion == null && this.maxVersion == null;
    }

    boolean isSingleVersion() {
        return Objects.equals(this.minVersion, this.maxVersion) && this.minIncluded && this.maxIncluded;
    }

    boolean allows(Version version) {
        if (this.minVersion != null && (version.compareTo(this.minVersion) < 0 || !this.minIncluded && version.equals(this.minVersion))) {
            return false;
        }
        if (this.maxVersion != null) {
            return version.compareTo(this.maxVersion) <= 0 && (this.maxIncluded || !version.equals(this.maxVersion));
        }
        return true;
    }

    boolean allowsAll(VersionRange other) {
        return !other.allowsLower(this) && !other.allowsHigher(this);
    }

    boolean allowsAny(VersionRange other) {
        return !other.strictlyLower(this) && !other.strictlyHigher(this);
    }

    Optional<VersionRange> intersect(VersionRange other) {
        boolean intersectMaxIncluded;
        Version intersectMaxVersion;
        boolean intersectMinIncluded;
        Version intersectMinVersion;
        if (this.allowsLower(other)) {
            if (this.strictlyLower(other)) {
                return Optional.empty();
            }
            intersectMinVersion = other.minVersion;
            intersectMinIncluded = other.minIncluded;
        } else {
            if (other.strictlyLower(this)) {
                return Optional.empty();
            }
            intersectMinVersion = this.minVersion;
            intersectMinIncluded = this.minIncluded;
        }
        if (this.allowsHigher(other)) {
            intersectMaxVersion = other.maxVersion;
            intersectMaxIncluded = other.maxIncluded;
        } else {
            intersectMaxVersion = this.maxVersion;
            intersectMaxIncluded = this.maxIncluded;
        }
        if (intersectMinVersion == null && intersectMaxVersion == null) {
            return Optional.of(new VersionRange(null, null, false, false));
        }
        if (Objects.equals(intersectMinVersion, intersectMaxVersion)) {
            if (!intersectMinIncluded || !intersectMaxIncluded) {
                throw new IllegalStateException("Min and max not included in intersection");
            }
            return Optional.of(new VersionRange(intersectMinVersion));
        }
        return Optional.of(new VersionRange(intersectMinVersion, intersectMaxVersion, intersectMinIncluded, intersectMaxIncluded));
    }

    List<VersionRange> difference(VersionRange other) {
        VersionRange after;
        VersionRange before;
        if (!this.allowsAny(other)) {
            return List.of(this);
        }
        if (!this.allowsLower(other)) {
            before = null;
        } else if (Objects.equals(this.minVersion, other.minVersion)) {
            if (!this.minIncluded || other.minIncluded) {
                throw new IllegalStateException("Minimum included cannot equal other minimum included");
            }
            if (this.minVersion == null) {
                throw new IllegalStateException("Minimum version cannot be null");
            }
            before = new VersionRange(this.minVersion);
        } else {
            before = new VersionRange(this.minVersion, other.minVersion, this.minIncluded, !other.minIncluded);
        }
        if (!this.allowsHigher(other)) {
            after = null;
        } else if (Objects.equals(this.maxVersion, other.maxVersion)) {
            if (!this.maxIncluded || other.maxIncluded) {
                throw new IllegalStateException("Maximum included cannot equal other maximum included");
            }
            if (this.maxVersion == null) {
                throw new IllegalStateException("Maximum version cannot be null");
            }
            after = new VersionRange(this.maxVersion);
        } else {
            after = new VersionRange(other.maxVersion, this.maxVersion, !other.maxIncluded, this.maxIncluded);
        }
        if (before == null && after == null) {
            return List.of();
        }
        if (before == null) {
            return List.of(after);
        }
        if (after == null) {
            return List.of(before);
        }
        return List.of(before, after);
    }

    boolean isAdjacent(VersionRange other) {
        if (Objects.equals(this.maxVersion, other.minVersion)) {
            return this.maxIncluded ^ other.minIncluded;
        }
        if (Objects.equals(this.minVersion, other.maxVersion)) {
            return this.minIncluded ^ other.maxIncluded;
        }
        return false;
    }

    VersionRange merge(VersionRange other) {
        boolean unionMaxIncluded;
        Version unionMaxVersion;
        boolean unionMinIncluded;
        Version unionMinVersion;
        if (this.allowsLower(other)) {
            unionMinVersion = this.minVersion;
            unionMinIncluded = this.minIncluded;
        } else {
            unionMinVersion = other.minVersion;
            unionMinIncluded = other.minIncluded;
        }
        if (this.allowsHigher(other)) {
            unionMaxVersion = this.maxVersion;
            unionMaxIncluded = this.maxIncluded;
        } else {
            unionMaxVersion = other.maxVersion;
            unionMaxIncluded = other.maxIncluded;
        }
        return new VersionRange(unionMinVersion, unionMaxVersion, unionMinIncluded, unionMaxIncluded);
    }

    boolean allowsLower(VersionRange other) {
        if (this.minVersion == null) {
            return other.minVersion != null;
        }
        if (other.minVersion == null) {
            return false;
        }
        int result = this.minVersion.compareTo(other.minVersion);
        if (result < 0) {
            return true;
        }
        if (result > 0) {
            return false;
        }
        return this.minIncluded && !other.minIncluded;
    }

    boolean allowsHigher(VersionRange other) {
        if (this.maxVersion == null) {
            return other.maxVersion != null;
        }
        if (other.maxVersion == null) {
            return false;
        }
        int result = this.maxVersion.compareTo(other.maxVersion);
        if (result > 0) {
            return true;
        }
        if (result < 0) {
            return false;
        }
        return this.maxIncluded && !other.maxIncluded;
    }

    boolean strictlyLower(VersionRange other) {
        if (this.maxVersion == null || other.minVersion == null) {
            return false;
        }
        int result = this.maxVersion.compareTo(other.minVersion);
        if (result < 0) {
            return true;
        }
        if (result > 0) {
            return false;
        }
        return !this.maxIncluded || !other.minIncluded;
    }

    boolean strictlyHigher(VersionRange other) {
        return other.strictlyLower(this);
    }

    @Override
    public int compareTo(VersionRange other) {
        Supplier<Integer> compareMax = () -> {
            if (this.maxVersion == null) {
                return other.getMaxVersion() == null ? 0 : 1;
            }
            if (other.getMaxVersion() == null) {
                return -1;
            }
            int result = this.maxVersion.compareTo(other.getMaxVersion());
            if (result != 0) {
                return result;
            }
            if (this.maxIncluded != other.isMaxIncluded()) {
                return this.maxIncluded ? 1 : -1;
            }
            return 0;
        };
        if (this.minVersion == null) {
            return other.getMinVersion() == null ? compareMax.get() : -1;
        }
        if (other.getMinVersion() == null) {
            return 1;
        }
        int result = this.minVersion.compareTo(other.getMinVersion());
        if (result != 0) {
            return result;
        }
        if (this.minIncluded != other.isMinIncluded()) {
            return this.minIncluded ? -1 : 1;
        }
        return compareMax.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((VersionRange)obj) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.minVersion, this.maxVersion, this.minIncluded, this.maxIncluded);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.minVersion == null) {
            builder.append("(,");
        } else {
            builder.append(this.minIncluded ? (char)'[' : '(');
            builder.append(this.minVersion);
            if (!(this.minVersion.equals(this.maxVersion) && this.minIncluded && this.maxIncluded)) {
                builder.append(',');
            }
        }
        if (this.maxVersion == null) {
            builder.append(')');
        } else {
            if (!(this.maxVersion.equals(this.minVersion) && this.minIncluded && this.maxIncluded)) {
                builder.append(this.maxVersion);
            }
            builder.append(this.maxIncluded ? (char)']' : ')');
        }
        return builder.toString();
    }
}

