/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.calver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.cthing.versionparser.AbstractVersion;
import org.cthing.versionparser.Version;
import org.cthing.versionparser.calver.Component;
import org.cthing.versionparser.calver.ComponentCategory;

public class CalendarVersion
extends AbstractVersion {
    private static final Set<String> PRERELEASE_QUALIFIERS = Set.of("alpha", "beta", "cr", "dev", "milestone", "rc", "snapshot");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("\\.");
    private static final String UNDEFINED_MARKER = "uNdeF";
    private static final Pattern HAS_DIGITS_PATTERN = Pattern.compile(".*\\d.*");
    private static final String EXTRACT_DIGITS = "(?<=\\D)(?=\\d)";
    @Nullable
    private Component year;
    @Nullable
    private Component month;
    @Nullable
    private Component day;
    @Nullable
    private Component week;
    @Nullable
    private Component major;
    @Nullable
    private Component minor;
    @Nullable
    private Component patch;
    private final List<Component> components;
    private final boolean preRelease;
    private List<String> modifierComponents;

    CalendarVersion(String originalFormat, List<Component> components) {
        super(originalFormat);
        this.components = Collections.unmodifiableList(components);
        this.modifierComponents = new ArrayList<String>();
        block10: for (Component component : components) {
            switch (component.getCategory()) {
                case MAJOR: {
                    this.major = component;
                    continue block10;
                }
                case MINOR: {
                    this.minor = component;
                    continue block10;
                }
                case PATCH: {
                    this.patch = component;
                    continue block10;
                }
                case YEAR: {
                    this.year = component;
                    continue block10;
                }
                case MONTH: {
                    this.month = component;
                    continue block10;
                }
                case WEEK: {
                    this.week = component;
                    continue block10;
                }
                case DAY: {
                    this.day = component;
                    continue block10;
                }
                case MODIFIER: {
                    this.modifierComponents = List.of(SEPARATOR_PATTERN.split(component.getValueStr()));
                    continue block10;
                }
            }
            throw new IllegalStateException("Unexpected value: " + component.getFormat());
        }
        if (this.modifierComponents.isEmpty()) {
            this.preRelease = false;
        } else {
            String modifier = this.modifierComponents.get(0).toLowerCase(Locale.ROOT);
            this.preRelease = PRERELEASE_QUALIFIERS.stream().anyMatch(modifier::startsWith);
        }
    }

    public List<Component> getComponents() {
        return this.components;
    }

    @Override
    public boolean isPreRelease() {
        return this.preRelease;
    }

    @Override
    public int compareTo(Version obj) {
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException("Expected instance of CalendarVersion but received " + obj.getClass().getName());
        }
        CalendarVersion otherVersion = (CalendarVersion)obj;
        int result = CalendarVersion.compareComponent(this.year, otherVersion.year);
        if (result != 0) {
            return result;
        }
        if (this.week != null) {
            result = CalendarVersion.compareComponent(this.week, otherVersion.week);
            if (result != 0) {
                return result;
            }
        } else {
            result = CalendarVersion.compareComponent(this.month, otherVersion.month);
            if (result != 0) {
                return result;
            }
            result = CalendarVersion.compareComponent(this.day, otherVersion.day);
            if (result != 0) {
                return result;
            }
        }
        if ((result = CalendarVersion.compareComponent(this.major, otherVersion.major)) != 0) {
            return result;
        }
        result = CalendarVersion.compareComponent(this.minor, otherVersion.minor);
        if (result != 0) {
            return result;
        }
        result = CalendarVersion.compareComponent(this.patch, otherVersion.patch);
        if (result != 0) {
            return result;
        }
        return CalendarVersion.compareModifiers(this.modifierComponents, otherVersion.modifierComponents);
    }

    private static int compareComponent(@Nullable Component comp1, @Nullable Component comp2) {
        if (comp1 == null && comp2 == null) {
            return 0;
        }
        if (comp1 == null) {
            return -1;
        }
        if (comp2 == null) {
            return 1;
        }
        assert (comp1.getCategory() == comp2.getCategory());
        assert (comp1.getCategory() != ComponentCategory.MODIFIER);
        return Integer.compare(comp1.getValue(), comp2.getValue());
    }

    private static int compareModifiers(List<String> modifiers1, List<String> modifiers2) {
        if (!modifiers1.isEmpty() && modifiers2.isEmpty()) {
            return -1;
        }
        if (modifiers1.isEmpty() && !modifiers2.isEmpty()) {
            return 1;
        }
        if (modifiers1.isEmpty()) {
            return 0;
        }
        int maxElements = Math.max(modifiers1.size(), modifiers2.size());
        int i = 0;
        do {
            String a = CalendarVersion.safeGet(modifiers1, i);
            String b = CalendarVersion.safeGet(modifiers2, i);
            ++i;
            if (UNDEFINED_MARKER.equals(a) && UNDEFINED_MARKER.equals(b)) {
                return 0;
            }
            if (UNDEFINED_MARKER.equals(b)) {
                return 1;
            }
            if (UNDEFINED_MARKER.equals(a)) {
                return -1;
            }
            if (a.equals(b)) continue;
            return CalendarVersion.compareModifier(a, b);
        } while (maxElements > i);
        return 0;
    }

    private static int compareModifier(String modifier1, String modifier2) {
        try {
            int aInt = Integer.parseInt(modifier1);
            int bInt = Integer.parseInt(modifier2);
            return Integer.compare(aInt, bInt);
        }
        catch (NumberFormatException aInt) {
            String[] tokenArr2;
            String[] tokenArr1;
            if (CalendarVersion.hasDigits(modifier1, modifier2) && (tokenArr1 = modifier1.split(EXTRACT_DIGITS))[0].equals((tokenArr2 = modifier2.split(EXTRACT_DIGITS))[0])) {
                int aInt2 = Integer.parseInt(tokenArr1[1]);
                int bInt = Integer.parseInt(tokenArr2[1]);
                return Integer.compare(aInt2, bInt);
            }
            int result = modifier1.compareTo(modifier2);
            if (result > 0) {
                return 1;
            }
            return result < 0 ? -1 : 0;
        }
    }

    private static boolean hasDigits(String a, String b) {
        return HAS_DIGITS_PATTERN.matcher(a).matches() && HAS_DIGITS_PATTERN.matcher(b).matches();
    }

    private static String safeGet(List<String> list, int idx) {
        assert (idx >= 0);
        return idx < list.size() ? list.get(idx) : UNDEFINED_MARKER;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day, this.week, this.major, this.minor, this.patch, this.modifierComponents);
    }
}

