/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.calver;

import java.util.Objects;
import org.cthing.versionparser.VersionParsingException;
import org.cthing.versionparser.calver.ComponentCategory;
import org.cthing.versionparser.calver.ComponentFormat;

public class Component {
    private static final int BASE_YEAR = 2000;
    private final ComponentFormat format;
    private final String valueStr;
    private final int value;

    Component(ComponentFormat format, String valueStr) throws VersionParsingException {
        this.format = format;
        this.valueStr = valueStr;
        if (format == ComponentFormat.MODIFIER) {
            this.value = 0;
        } else if (format == ComponentFormat.YY || format == ComponentFormat.ZERO_Y) {
            this.value = 2000 + Integer.parseInt(valueStr, 10);
            format.getCategory().validate(this.value);
        } else {
            this.value = Integer.parseInt(valueStr, 10);
            format.getCategory().validate(this.value);
        }
    }

    public ComponentCategory getCategory() {
        return this.format.getCategory();
    }

    ComponentFormat getFormat() {
        return this.format;
    }

    public String getValueStr() {
        return this.valueStr;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.valueStr;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Component component = (Component)obj;
        if (this.getCategory() != component.getCategory()) {
            return false;
        }
        if (this.getCategory() == ComponentCategory.MODIFIER) {
            return this.valueStr.equals(component.valueStr);
        }
        return this.value == component.value;
    }

    public int hashCode() {
        if (this.getCategory() == ComponentCategory.MODIFIER) {
            return Objects.hash(new Object[]{this.getCategory(), this.valueStr});
        }
        return Objects.hash(new Object[]{this.getCategory(), this.value});
    }
}

