/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.calver;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.cthing.versionparser.VersionParsingException;

public enum ComponentCategory {
    YEAR(integer -> integer >= 1900, "Invalid year '%d' (year >= 1900)"),
    MONTH(integer -> integer >= 1 && integer <= 12, "Invalid month '%d' (1 <= month <= 12)"),
    DAY(integer -> integer >= 1 && integer <= 31, "Invalid day '%d' (1 <= day <= 31)"),
    WEEK(integer -> integer >= 1 && integer <= 52, "Invalid week '%d' (1 <= week <= 52)"),
    MAJOR(integer -> integer >= 0, "Invalid major version '%d' (major >= 0)"),
    MINOR(integer -> integer >= 0, "Invalid minor version '%d' (minor >= 0)"),
    PATCH(integer -> integer >= 0, "Invalid patch version '%d' (patch >= 0)"),
    MODIFIER(null, "");

    @Nullable
    private final Predicate<Integer> validator;
    private final String validationMessage;

    private ComponentCategory(Predicate<Integer> validator, String message) {
        this.validator = validator;
        this.validationMessage = message;
    }

    void validate(int value) throws VersionParsingException {
        if (this.validator != null && !this.validator.test(value)) {
            throw new VersionParsingException(String.format(this.validationMessage, value));
        }
    }
}

