/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.cthing.versionparser.AbstractVersion;
import org.cthing.versionparser.Version;

public final class GradleVersion
extends AbstractVersion {
    private static final Integer QUALIFIER_DEV = -1;
    private static final Integer QUALIFIER_RC = 1;
    private static final Integer QUALIFIER_SNAPSHOT = 2;
    private static final Integer QUALIFIER_FINAL = 3;
    private static final Integer QUALIFIER_GA = 4;
    private static final Integer QUALIFIER_RELEASE = 5;
    private static final Integer QUALIFIER_SP = 6;
    private static final Map<String, Integer> SPECIAL_MEANINGS = Map.of("dev", QUALIFIER_DEV, "rc", QUALIFIER_RC, "snapshot", QUALIFIER_SNAPSHOT, "final", QUALIFIER_FINAL, "ga", QUALIFIER_GA, "release", QUALIFIER_RELEASE, "sp", QUALIFIER_SP);
    private final List<String> components;
    private final List<Long> numericParts;
    private final GradleVersion baseVersion;

    private GradleVersion(String version, List<String> parts, @Nullable GradleVersion baseVersion) {
        super(version);
        this.components = Collections.unmodifiableList(parts);
        this.numericParts = parts.stream().map(GradleVersion::parseLong).toList();
        this.baseVersion = baseVersion == null ? this : baseVersion;
    }

    public boolean isQualified() {
        return this.baseVersion != this;
    }

    public GradleVersion getBaseVersion() {
        return this.baseVersion;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public List<Long> getNumericParts() {
        return this.numericParts;
    }

    @Override
    public boolean isPreRelease() {
        return this.isQualified() && this.components.stream().map(part -> SPECIAL_MEANINGS.get(part.toLowerCase(Locale.US))).filter(Objects::nonNull).findFirst().filter(qualifier -> QUALIFIER_DEV.equals(qualifier) || QUALIFIER_RC.equals(qualifier) || QUALIFIER_SNAPSHOT.equals(qualifier)).isPresent();
    }

    static GradleVersion parse(String version) {
        int pos;
        ArrayList<String> parts = new ArrayList<String>();
        boolean digit = false;
        boolean lastWasDelimiter = false;
        int startPart = 0;
        int endBase = 0;
        int endBaseStr = 0;
        for (pos = 0; pos < version.length(); ++pos) {
            char ch = version.charAt(pos);
            if (ch == '.' || ch == '_' || ch == '-' || ch == '+') {
                if (lastWasDelimiter && ch == '+') {
                    lastWasDelimiter = false;
                } else {
                    parts.add(version.substring(startPart, pos));
                    startPart = pos + 1;
                    lastWasDelimiter = true;
                }
                digit = false;
                if (ch == '.' || endBaseStr != 0) continue;
                endBase = parts.size();
                endBaseStr = pos;
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                if (!digit && pos > startPart) {
                    if (endBaseStr == 0) {
                        endBase = parts.size() + 1;
                        endBaseStr = pos;
                    }
                    parts.add(version.substring(startPart, pos));
                    startPart = pos;
                }
                digit = true;
                lastWasDelimiter = false;
                continue;
            }
            if (digit) {
                if (endBaseStr == 0) {
                    endBase = parts.size() + 1;
                    endBaseStr = pos;
                }
                parts.add(version.substring(startPart, pos));
                startPart = pos;
            }
            digit = false;
            lastWasDelimiter = false;
        }
        if (pos > startPart) {
            parts.add(version.substring(startPart, pos));
        }
        GradleVersion base = null;
        if (endBaseStr > 0) {
            base = new GradleVersion(version.substring(0, endBaseStr), parts.subList(0, endBase), null);
        }
        return new GradleVersion(version, parts, base);
    }

    @Nullable
    private static Long parseLong(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        char firstChar = str.charAt(0);
        if (firstChar == '-' || firstChar == '+' ? str.length() == 1 || !Character.isDigit(str.charAt(1)) : !Character.isDigit(firstChar)) {
            return null;
        }
        try {
            return Long.parseLong(str, 10);
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @Override
    public int compareTo(Version obj) {
        int partIdx;
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException("Expected instance of GradleVersion but received " + obj.getClass().getName());
        }
        GradleVersion otherVersion = (GradleVersion)obj;
        if (this.toString().equals(otherVersion.toString())) {
            return 0;
        }
        for (partIdx = 0; partIdx < this.components.size() && partIdx < otherVersion.components.size(); ++partIdx) {
            boolean is2Number;
            String part1 = this.components.get(partIdx);
            String part2 = otherVersion.components.get(partIdx);
            Long numericPart1 = this.numericParts.get(partIdx);
            Long numericPart2 = otherVersion.numericParts.get(partIdx);
            boolean is1Number = numericPart1 != null;
            boolean bl = is2Number = numericPart2 != null;
            if (part1.equals(part2)) continue;
            if (is1Number && !is2Number) {
                return 1;
            }
            if (!is1Number && is2Number) {
                return -1;
            }
            if (is1Number) {
                int result = numericPart1.compareTo(numericPart2);
                if (result == 0) continue;
                return result;
            }
            Integer sm1 = SPECIAL_MEANINGS.get(part1.toLowerCase(Locale.US));
            Integer sm2 = SPECIAL_MEANINGS.get(part2.toLowerCase(Locale.US));
            if (sm1 != null) {
                sm2 = sm2 == null ? Integer.valueOf(0) : sm2;
                return sm1 - sm2;
            }
            if (sm2 != null) {
                return -sm2.intValue();
            }
            return part1.compareTo(part2);
        }
        if (partIdx < this.components.size()) {
            return this.numericParts.get(partIdx) == null ? -1 : 1;
        }
        if (partIdx < otherVersion.components.size()) {
            return otherVersion.numericParts.get(partIdx) == null ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        int code = 7;
        for (int i = 0; i < this.components.size(); ++i) {
            Long numericPart = this.numericParts.get(i);
            code = 31 * code + (numericPart == null ? this.components.get(i).hashCode() : numericPart.hashCode());
        }
        return code;
    }
}

