/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.gradle;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cthing.versionparser.VersionConstraint;
import org.cthing.versionparser.VersionParsingException;
import org.cthing.versionparser.annotations.UtilityClass;
import org.cthing.versionparser.gradle.GradleVersion;

public final class GradleVersionScheme {
    private static final String LOWER_INFINITE = "(";
    private static final String UPPER_INFINITE = ")";
    private static final String SEPARATOR = ",";
    private static final String LI_PATTERN = "\\(";
    private static final String UI_PATTERN = "\\)";
    private static final String SEP_PATTERN = "\\s*\\,\\s*";
    private static final String OPEN_INC = "[";
    private static final String OPEN_EXC = "]";
    private static final String OPEN_EXC_MAVEN = "(";
    private static final String OPEN_INC_PATTERN = "\\[";
    private static final String OPEN_EXC_PATTERN = "\\]\\(";
    private static final String OPEN_PATTERN = "[\\[\\]\\(]";
    private static final String CLOSE_INC = "]";
    private static final String CLOSE_EXC = "[";
    private static final String CLOSE_EXC_MAVEN = ")";
    private static final String CLOSE_INC_PATTERN = "\\]";
    private static final String CLOSE_EXC_PATTERN = "\\[\\)";
    private static final String CLOSE_PATTERN = "[\\]\\[\\)]";
    private static final String ANY_NON_SPECIAL_PATTERN = "[^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]";
    private static final String LOWER_INFINITE_PATTERN = "\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String UPPER_INFINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)";
    private static final String FINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String INFINITE_PATTERN = "[\\]\\(]\\s*\\,\\s*[\\[\\)]";
    private static final String INFINITE_DYNAMIC_PATTERN = "\\s*\\+\\s*";
    private static final String SINGLE_VALUE_PATTERN = "\\[\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\]";
    private static final Pattern FINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern INFINITE_RANGE = Pattern.compile("[\\]\\(]\\s*\\,\\s*[\\[\\)]");
    private static final Pattern INFINITE_DYNAMIC_RANGE = Pattern.compile("\\s*\\+\\s*");
    private static final Pattern LOWER_INFINITE_RANGE = Pattern.compile("\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern UPPER_INFINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private static final Pattern SINGLE_VALUE_RANGE = Pattern.compile("\\[\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\]");
    private static final Pattern ALL_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)|" + INFINITE_RANGE + "|" + INFINITE_DYNAMIC_RANGE + "|" + SINGLE_VALUE_RANGE);

    @UtilityClass
    private GradleVersionScheme() {
    }

    public static GradleVersion parseVersion(String version) {
        return GradleVersion.parse(version);
    }

    public static VersionConstraint parseConstraint(String constraint) throws VersionParsingException {
        if (ALL_RANGE.matcher(constraint).matches()) {
            return GradleVersionScheme.parseRange(constraint);
        }
        if (constraint.endsWith("+")) {
            return GradleVersionScheme.parseDynamicVersion(constraint);
        }
        return GradleVersionScheme.parseSingleVersion(constraint);
    }

    private static VersionConstraint parseRange(String constraint) throws VersionParsingException {
        Matcher matcher = INFINITE_DYNAMIC_RANGE.matcher(constraint);
        if (matcher.matches()) {
            return VersionConstraint.ANY;
        }
        matcher = FINITE_RANGE.matcher(constraint);
        if (matcher.matches()) {
            GradleVersion minVersion = GradleVersion.parse(matcher.group(1));
            GradleVersion maxVersion = GradleVersion.parse(matcher.group(2));
            boolean minIncluded = constraint.startsWith("[");
            boolean maxIncluded = constraint.endsWith("]");
            return new VersionConstraint(minVersion, maxVersion, minIncluded, maxIncluded);
        }
        matcher = LOWER_INFINITE_RANGE.matcher(constraint);
        if (matcher.matches()) {
            GradleVersion maxVersion = GradleVersion.parse(matcher.group(1));
            boolean maxIncluded = constraint.endsWith("]");
            return new VersionConstraint(null, maxVersion, false, maxIncluded);
        }
        matcher = UPPER_INFINITE_RANGE.matcher(constraint);
        if (matcher.matches()) {
            GradleVersion minVersion = GradleVersion.parse(matcher.group(1));
            boolean minIncluded = constraint.startsWith("[");
            return new VersionConstraint(minVersion, null, minIncluded, false);
        }
        matcher = INFINITE_RANGE.matcher(constraint);
        if (matcher.matches()) {
            return VersionConstraint.ANY;
        }
        matcher = SINGLE_VALUE_RANGE.matcher(constraint);
        if (matcher.matches()) {
            GradleVersion version = GradleVersion.parse(matcher.group(1));
            return new VersionConstraint(version);
        }
        throw new VersionParsingException("Not a version range selector: " + constraint);
    }

    private static VersionConstraint parseDynamicVersion(String constraint) throws VersionParsingException {
        GradleVersion version = GradleVersion.parse(constraint);
        ArrayList<String> parts = new ArrayList<String>(version.getComponents());
        assert ("+".equals(parts.get(parts.size() - 1)));
        if (parts.size() < 2) {
            throw new VersionParsingException("Invalid dynamic version " + constraint);
        }
        String minVersionStr = IntStream.range(0, parts.size() - 1).mapToObj(parts::get).collect(Collectors.joining("."));
        int pos = parts.size() - 2;
        Long numericPart = version.getNumericParts().get(pos);
        if (numericPart == null) {
            throw new VersionParsingException("Dynamic versions must have a numeric component before the '+'");
        }
        parts.set(pos, String.valueOf(numericPart + 1L));
        String maxVersionStr = IntStream.range(0, parts.size() - 1).mapToObj(parts::get).collect(Collectors.joining("."));
        GradleVersion minVersion = GradleVersion.parse(minVersionStr);
        GradleVersion maxVersion = GradleVersion.parse(maxVersionStr);
        return new VersionConstraint(minVersion, maxVersion, true, false);
    }

    private static VersionConstraint parseSingleVersion(String constraint) {
        GradleVersion version = GradleVersion.parse(constraint);
        return new VersionConstraint(version, null, true, false);
    }
}

