/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.maven;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.cthing.versionparser.AbstractVersion;
import org.cthing.versionparser.Version;

public final class MvnVersion
extends AbstractVersion {
    private final List<Component> components;

    private MvnVersion(String version, List<Component> components) {
        super(version);
        this.components = components;
    }

    public List<String> getComponents() {
        return this.components.stream().map(Component::toString).toList();
    }

    @Override
    public boolean isPreRelease() {
        return this.components.stream().filter(Component::isQualifier).mapToInt(component -> (Integer)component.value()).anyMatch(qualifier -> qualifier != 0 && qualifier != 1);
    }

    static MvnVersion parse(String version) {
        String trimmedVersion = version.trim();
        ArrayList<Component> comps = new ArrayList<Component>();
        new Tokenizer(trimmedVersion).forEach(comps::add);
        MvnVersion.trimPadding(comps);
        return new MvnVersion(trimmedVersion, Collections.unmodifiableList(comps));
    }

    private static void trimPadding(List<Component> comps) {
        int end;
        Boolean number = null;
        for (int i = end = comps.size() - 1; i > 0; --i) {
            Component comp = comps.get(i);
            if (!Boolean.valueOf(comp.isNumber()).equals(number)) {
                end = i;
                number = comp.isNumber();
            }
            if (end != i || i != comps.size() - 1 && comps.get(i - 1).isNumber() != comp.isNumber() || comp.compareTo(null) != 0) continue;
            comps.remove(i);
            --end;
        }
    }

    @Override
    public int compareTo(Version obj) {
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException("Expected instance of MvnVersion but received " + obj.getClass().getName());
        }
        List<Component> those = ((MvnVersion)obj).components;
        List<Component> these = this.components;
        boolean isNumber = true;
        int index = 0;
        while (index < these.size() || index < those.size()) {
            if (index >= these.size()) {
                return -MvnVersion.comparePadding(those, index, null);
            }
            if (index >= those.size()) {
                return MvnVersion.comparePadding(these, index, null);
            }
            Component thisComponent = these.get(index);
            Component thatComponent = those.get(index);
            if (thisComponent.isNumber() != thatComponent.isNumber()) {
                return isNumber == thisComponent.isNumber() ? MvnVersion.comparePadding(these, index, isNumber) : -MvnVersion.comparePadding(those, index, isNumber);
            }
            int rel = thisComponent.compareTo(thatComponent);
            if (rel != 0) {
                return rel;
            }
            isNumber = thisComponent.isNumber();
            ++index;
        }
        return 0;
    }

    private static int comparePadding(List<Component> comps, int index, @Nullable Boolean number) {
        int rel = 0;
        for (int i = index; i < comps.size(); ++i) {
            Component comp = comps.get(i);
            if (number != null && number.booleanValue() != comp.isNumber() || (rel = comp.compareTo(null)) != 0) break;
        }
        return rel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.components);
    }

    private static final class Tokenizer
    implements Iterable<Component>,
    Iterator<Component> {
        static final int QUALIFIER_ALPHA = -5;
        static final int QUALIFIER_BETA = -4;
        static final int QUALIFIER_MILESTONE = -3;
        static final int QUALIFIER_RC = -2;
        static final int QUALIFIER_SNAPSHOT = -1;
        static final int QUALIFIER_RELEASE = 0;
        static final int QUALIFIER_SP = 1;
        private static final int MAX_INTEGER_CHARS = 10;
        private static final Map<String, Integer> QUALIFIERS = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        private final String version;
        private int index;
        @Nullable
        private Token token;

        Tokenizer(String version) {
            this.version = version.isEmpty() ? "0" : version;
        }

        @Override
        public Iterator<Component> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            int n = this.version.length();
            if (this.index >= n) {
                return false;
            }
            State state = State.INITIAL;
            int start = this.index;
            int end = n;
            boolean terminatedByNumber = false;
            while (this.index < n) {
                char c = this.version.charAt(this.index);
                if (c == '.' || c == '-' || c == '_') {
                    end = this.index++;
                    break;
                }
                int digit = Character.digit(c, 10);
                if (digit >= 0) {
                    if (state == State.LETTER) {
                        end = this.index;
                        terminatedByNumber = true;
                        break;
                    }
                    if (state == State.LEADING_ZERO) {
                        ++start;
                    }
                    state = state == State.REGULAR_DIGIT || digit > 0 ? State.REGULAR_DIGIT : State.LEADING_ZERO;
                } else {
                    if (state == State.REGULAR_DIGIT || state == State.LEADING_ZERO) {
                        end = this.index;
                        break;
                    }
                    state = State.LETTER;
                }
                ++this.index;
            }
            if (end - start > 0) {
                String value = this.version.substring(start, end);
                boolean isNumber = state == State.REGULAR_DIGIT || state == State.LEADING_ZERO;
                this.token = new Token(value, isNumber, terminatedByNumber);
            } else {
                this.token = new Token("0", true, terminatedByNumber);
            }
            return true;
        }

        @Override
        public Component next() {
            Integer qualifier;
            if (this.token == null) {
                throw new IllegalStateException("token cannot be null");
            }
            if (this.token.isNumber) {
                try {
                    return this.token.value.length() < 10 ? new Component(4, Integer.valueOf(this.token.value), this.token.value) : new Component(5, new BigInteger(this.token.value), this.token.value);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            if (this.index >= this.version.length()) {
                if ("min".equalsIgnoreCase(this.token.value)) {
                    return Component.MIN;
                }
                if ("max".equalsIgnoreCase(this.token.value)) {
                    return Component.MAX;
                }
            }
            if (this.token.terminatedByNumber && this.token.value.length() == 1) {
                switch (this.token.value.charAt(0)) {
                    case 'A': 
                    case 'a': {
                        return new Component(2, -5, this.token.value);
                    }
                    case 'B': 
                    case 'b': {
                        return new Component(2, -4, this.token.value);
                    }
                    case 'M': 
                    case 'm': {
                        return new Component(2, -3, this.token.value);
                    }
                }
            }
            return (qualifier = QUALIFIERS.get(this.token.value)) == null ? new Component(3, this.token.value.toLowerCase(Locale.ENGLISH), this.token.value) : new Component(2, qualifier, this.token.value);
        }

        public String toString() {
            return this.token == null ? "" : this.token.value;
        }

        static {
            QUALIFIERS.put("alpha", -5);
            QUALIFIERS.put("beta", -4);
            QUALIFIERS.put("milestone", -3);
            QUALIFIERS.put("cr", -2);
            QUALIFIERS.put("rc", -2);
            QUALIFIERS.put("snapshot", -1);
            QUALIFIERS.put("ga", 0);
            QUALIFIERS.put("final", 0);
            QUALIFIERS.put("release", 0);
            QUALIFIERS.put("", 0);
            QUALIFIERS.put("sp", 1);
        }

        private static enum State {
            INITIAL,
            LETTER,
            LEADING_ZERO,
            REGULAR_DIGIT;

        }

        private record Token(String value, boolean isNumber, boolean terminatedByNumber) {
        }
    }

    private record Component(int kind, Object value, String original) implements Comparable<Component>
    {
        static final int KIND_MAX = 8;
        static final int KIND_BIGINT = 5;
        static final int KIND_INT = 4;
        static final int KIND_STRING = 3;
        static final int KIND_QUALIFIER = 2;
        static final int KIND_MIN = 0;
        static final Component MAX = new Component(8, "max", "max");
        static final Component MIN = new Component(0, "min", "min");

        public boolean isNumber() {
            return (this.kind & 2) == 0;
        }

        public boolean isQualifier() {
            return this.kind == 2;
        }

        public boolean isEmpty() {
            return switch (this.kind) {
                case 0, 8 -> false;
                case 5 -> BigInteger.ZERO.equals(this.value);
                case 2, 4 -> {
                    if ((Integer)this.value == 0) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> ((CharSequence)this.value).isEmpty();
                default -> throw new IllegalStateException("unknown version component kind " + this.kind);
            };
        }

        @Override
        public int compareTo(@Nullable Component other) {
            int rel;
            if (other == null) {
                rel = switch (this.kind) {
                    case 0 -> -1;
                    case 3, 5, 8 -> 1;
                    case 2, 4 -> (Integer)this.value;
                    default -> throw new IllegalStateException("unknown version component kind " + this.kind);
                };
            } else {
                rel = this.kind - other.kind;
                if (rel == 0) {
                    rel = switch (this.kind) {
                        case 0, 8 -> rel;
                        case 5 -> ((BigInteger)this.value).compareTo((BigInteger)other.value);
                        case 2, 4 -> ((Integer)this.value).compareTo((Integer)other.value);
                        case 3 -> ((String)this.value).compareToIgnoreCase((String)other.value);
                        default -> throw new IllegalStateException("unknown version component kind: " + this.kind);
                    };
                }
            }
            return rel;
        }

        @Override
        public String toString() {
            return this.isQualifier() ? this.original : String.valueOf(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((Component)obj) == 0;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.kind, this.value);
        }
    }
}

