/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.maven;

import java.util.ArrayList;
import org.cthing.versionparser.VersionConstraint;
import org.cthing.versionparser.VersionParsingException;
import org.cthing.versionparser.VersionRange;
import org.cthing.versionparser.annotations.UtilityClass;
import org.cthing.versionparser.maven.MvnVersion;

public final class MvnVersionScheme {
    @UtilityClass
    private MvnVersionScheme() {
    }

    public static MvnVersion parseVersion(String version) {
        return MvnVersion.parse(version);
    }

    public static VersionConstraint parseConstraint(String constraint) throws VersionParsingException {
        ArrayList<VersionRange> ranges = new ArrayList<VersionRange>();
        String constraintBuffer = constraint.trim();
        if (constraintBuffer.isEmpty()) {
            throw new VersionParsingException("Constraint cannot be empty or blank");
        }
        while (constraintBuffer.startsWith("[") || constraintBuffer.startsWith("(")) {
            int index2;
            int index1 = constraintBuffer.indexOf(41);
            int index = index2 = constraintBuffer.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index = index1;
            }
            if (index < 0) {
                throw new VersionParsingException("Unbounded version range " + constraint);
            }
            VersionRange range = MvnVersionScheme.parseRange(constraintBuffer.substring(0, index + 1));
            ranges.add(range);
            if (!(constraintBuffer = constraintBuffer.substring(index + 1).trim()).startsWith(",")) continue;
            constraintBuffer = constraintBuffer.substring(1).trim();
        }
        if (!constraintBuffer.isEmpty() && !ranges.isEmpty()) {
            throw new VersionParsingException("Invalid version range " + constraint + ", expected [ or ( but got " + constraintBuffer);
        }
        if (ranges.isEmpty()) {
            MvnVersion version = MvnVersionScheme.parseVersion(constraint);
            return new VersionConstraint(version, null, true, false);
        }
        return new VersionConstraint(ranges);
    }

    private static VersionRange parseRange(String range) throws VersionParsingException {
        MvnVersion maxVersion;
        MvnVersion minVersion;
        boolean maxIncluded;
        boolean minIncluded;
        String rangeBuffer = range;
        if (range.startsWith("[")) {
            minIncluded = true;
        } else if (range.startsWith("(")) {
            minIncluded = false;
        } else {
            throw new VersionParsingException("Invalid version range '" + range + "', a range must start with either [ or (");
        }
        if (range.endsWith("]")) {
            maxIncluded = true;
        } else if (range.endsWith(")")) {
            maxIncluded = false;
        } else {
            throw new VersionParsingException("Invalid version range '" + range + "', a range must end with either ] or )");
        }
        rangeBuffer = rangeBuffer.substring(1, rangeBuffer.length() - 1);
        int index = rangeBuffer.indexOf(44);
        if (index < 0) {
            if (!minIncluded || !maxIncluded) {
                throw new VersionParsingException("Invalid version range '" + range + "', single version must be surrounded by []");
            }
            String version = rangeBuffer.trim();
            if (version.endsWith(".*")) {
                String prefix = version.substring(0, version.length() - 1);
                minVersion = MvnVersion.parse(prefix + "min");
                maxVersion = MvnVersion.parse(prefix + "max");
            } else {
                maxVersion = minVersion = MvnVersion.parse(version);
            }
        } else {
            String minVersionStr = rangeBuffer.substring(0, index).trim();
            String maxVersionStr = rangeBuffer.substring(index + 1).trim();
            if (maxVersionStr.contains(",")) {
                throw new VersionParsingException("Invalid version range '" + range + "', bounds may not contain additional ','");
            }
            minVersion = minVersionStr.isEmpty() ? null : MvnVersion.parse(minVersionStr);
            MvnVersion mvnVersion = maxVersion = maxVersionStr.isEmpty() ? null : MvnVersion.parse(maxVersionStr);
            if (maxVersion != null && minVersion != null && maxVersion.compareTo(minVersion) < 0) {
                throw new VersionParsingException("Invalid version range '" + range + "', lower bound must not be greater than upper bound");
            }
        }
        return new VersionRange(minVersion, maxVersion, minIncluded, maxIncluded);
    }
}

