/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.firebase;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ServiceOptions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.FirebaseAuth;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleApiFirebaseModule
extends AbstractModule {
    public static final String API_PREFIX = "firebase";
    private static final Logger logger = LoggerFactory.getLogger(GoogleApiFirebaseModule.class);

    @Provides
    @Singleton
    FirebaseAuth provideIdentityHandler(IdentityApiInit init) throws IOException {
        FirebaseOptions options;
        logger.info("credential.firebase.on: " + init.credentialOn);
        logger.info("credential.firebase.fileName:" + init.fileName);
        logger.info("credential.firebase.projectId: " + init.projectId);
        logger.info("credential.firebase.databaseName: " + init.databaseName);
        logger.info("credential.firebase.serviceAccountEmail: " + init.serviceAccount);
        String databaseName = init.databaseName;
        String projectId = init.projectId;
        if (Strings.isNullOrEmpty((String)projectId)) {
            projectId = ServiceOptions.getDefaultProjectId();
        }
        if (Strings.isNullOrEmpty((String)databaseName) && projectId != null) {
            databaseName = projectId;
        }
        if (Strings.isNullOrEmpty((String)databaseName)) {
            String msg = "The property 'credential.firebase.databaseName' is mandatory.";
            throw new IllegalArgumentException(msg);
        }
        String databaseUrl = "https://" + databaseName + ".firebaseio.com";
        logger.info("The final Firebase database URL: " + databaseUrl);
        if (!init.credentialOn) {
            FirebaseOptions.Builder builder = new FirebaseOptions.Builder().setCredentials(GoogleCredentials.getApplicationDefault()).setDatabaseUrl(databaseUrl);
            if (!Strings.isNullOrEmpty((String)init.serviceAccount)) {
                builder.setServiceAccountId(init.serviceAccount);
            }
            options = builder.build();
            logger.info("Firebase-admin built with application default credentials.");
        } else {
            if (Strings.isNullOrEmpty((String)init.fileName)) {
                String msg = "The property 'credential.firebase.fileName' for current configuration is mandatory.";
                throw new IllegalArgumentException(msg);
            }
            URL url = GoogleApiFirebaseModule.class.getResource(init.fileName);
            if (url == null) {
                String msg = "The file defined by property 'credential.firebase.fileName' " + init.fileName + " has not been found.";
                throw new IllegalArgumentException(msg);
            }
            FileInputStream serviceAccount = new FileInputStream(url.getPath());
            FirebaseOptions.Builder builder = new FirebaseOptions.Builder().setCredentials(GoogleCredentials.fromStream((InputStream)serviceAccount)).setDatabaseUrl(databaseUrl);
            if (!Strings.isNullOrEmpty((String)init.serviceAccount)) {
                builder.setServiceAccountId(init.serviceAccount);
            }
            options = builder.build();
            logger.info("Firebase-admin built with credentials from file.");
        }
        FirebaseApp.initializeApp((FirebaseOptions)options);
        return FirebaseAuth.getInstance();
    }

    static class IdentityApiInit {
        @Inject(optional=true)
        @Named(value="credential.firebase.on")
        boolean credentialOn = false;
        @Inject(optional=true)
        @Named(value="credential.firebase.fileName")
        String fileName;
        @Inject(optional=true)
        @Named(value="credential.firebase.projectId")
        String projectId;
        @Inject(optional=true)
        @Named(value="credential.firebase.databaseName")
        String databaseName;
        @Inject(optional=true)
        @Named(value="credential.firebase.serviceAccountEmail")
        String serviceAccount;

        IdentityApiInit() {
        }
    }
}

