/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.firebase;

import com.google.common.base.Strings;
import com.google.firebase.auth.FirebaseToken;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ctoolkit.restapi.client.firebase.IdentityHandler;
import org.ctoolkit.restapi.client.firebase.IdentityLoginListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ThreadSafe
public class IdentityCheckSessionFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(IdentityCheckSessionFilter.class);
    public static String SESSION_AUTH_USER_ATTRIBUTE = "_identity_filter_SESSION_AUTH_USER_ATTRIBUTE";
    public static String REDIRECT_PATH = "_identity_filter_REDIRECT_TO_IF_LOGGED_IN";
    public static String SIGN_UP_PATH = "_identity_filter_SIGN_UP_PATH";
    public static String LOGIN_PATH = "_identity_filter_LOGIN_PATH";
    public static String IGNORE_PATHS = "_identity_filter_IGNORE_PATHS";
    private final IdentityHandler identityHandler;
    private final Set<IdentityLoginListener> listeners;
    private String sessionAttribute;
    private String loggedInRedirect;
    private String signUpPath;
    private String loginPath;
    private Set<String> ignorePaths = new HashSet<String>();

    @Inject
    public IdentityCheckSessionFilter(IdentityHandler identityHandler, Set<IdentityLoginListener> listeners) {
        this.identityHandler = identityHandler;
        this.listeners = listeners;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.sessionAttribute = filterConfig.getInitParameter(SESSION_AUTH_USER_ATTRIBUTE);
        this.loggedInRedirect = filterConfig.getInitParameter(REDIRECT_PATH);
        this.signUpPath = filterConfig.getInitParameter(SIGN_UP_PATH);
        this.loginPath = filterConfig.getInitParameter(LOGIN_PATH);
        if (Strings.isNullOrEmpty((String)this.sessionAttribute)) {
            throw new IllegalArgumentException("Session attribute must be configured. ");
        }
        if (Strings.isNullOrEmpty((String)this.loggedInRedirect)) {
            this.loggedInRedirect = "";
            logger.warn("No REDIRECT_PATH has been configured!");
        }
        if (Strings.isNullOrEmpty((String)this.signUpPath)) {
            this.signUpPath = "";
            logger.warn("No SIGN_UP_PATH has been configured!");
        }
        if (Strings.isNullOrEmpty((String)this.loginPath)) {
            this.loginPath = "";
            logger.warn("No LOGIN_PATH has been configured!");
        }
        this.initIgnorePaths(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.ignoreServletPath(httpRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getSession().getAttribute(this.sessionAttribute) == null) {
            String signedEmail;
            FirebaseToken identity = this.identityHandler.resolveVerifyToken(httpRequest);
            String string = signedEmail = identity != null ? identity.getEmail() : null;
            if (signedEmail != null) {
                for (IdentityLoginListener listener : this.listeners) {
                    listener.processIdentity(httpRequest, httpResponse, identity, this.sessionAttribute);
                }
                this.identityHandler.delete(httpRequest, httpResponse);
            }
        } else if (!Strings.isNullOrEmpty((String)this.loggedInRedirect) && (httpRequest.getRequestURI().startsWith(this.signUpPath) || httpRequest.getRequestURI().startsWith(this.loginPath))) {
            httpResponse.sendRedirect(this.loggedInRedirect);
        }
        chain.doFilter(request, response);
    }

    private void initIgnorePaths(FilterConfig filterConfig) {
        String value = filterConfig.getInitParameter(IGNORE_PATHS);
        if (!Strings.isNullOrEmpty((String)value)) {
            for (String path : value.split(",")) {
                if (!(path = path.trim()).startsWith("/")) {
                    path = "/" + path;
                }
                this.ignorePaths.add(path);
            }
        }
    }

    private boolean ignoreServletPath(HttpServletRequest request) {
        String servletPath;
        if (!this.ignorePaths.isEmpty() && !Strings.isNullOrEmpty((String)(servletPath = request.getServletPath()))) {
            for (String toBeIgnored : this.ignorePaths) {
                if (!servletPath.startsWith(toBeIgnored)) continue;
                return true;
            }
        }
        return false;
    }

    public void destroy() {
    }
}

