/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.firebase;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseToken;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class IdentityHandler {
    public static final String FTOKEN = "ftoken";
    private static final Logger logger = LoggerFactory.getLogger(IdentityHandler.class);
    private final FirebaseAuth firebase;

    @Inject
    IdentityHandler(FirebaseAuth firebase) {
        this.firebase = firebase;
    }

    public FirebaseToken resolveVerifyToken(@Nonnull HttpServletRequest request) {
        String token = this.getToken((HttpServletRequest)Preconditions.checkNotNull((Object)request));
        FirebaseToken decodedToken = null;
        if (!Strings.isNullOrEmpty((String)token)) {
            try {
                decodedToken = (FirebaseToken)this.firebase.verifyIdTokenAsync(token).get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("Token verification has failed.", (Throwable)e);
            }
        }
        return decodedToken;
    }

    public final String getToken(@Nonnull HttpServletRequest request) {
        String token = request.getHeader(FTOKEN);
        if (!Strings.isNullOrEmpty((String)token)) {
            return token;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!FTOKEN.equals(cookie.getName())) continue;
            token = cookie.getValue();
        }
        return token;
    }

    public void delete(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!FTOKEN.equals(cookie.getName())) continue;
            cookie.setMaxAge(0);
            cookie.setValue("");
            cookie.setPath("/");
            response.addCookie(cookie);
        }
    }
}

