/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.sheets;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.SheetsScopes;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Set;
import javax.inject.Singleton;
import org.ctoolkit.restapi.client.AccessToken;
import org.ctoolkit.restapi.client.ApiToken;
import org.ctoolkit.restapi.client.ServiceUnavailableException;
import org.ctoolkit.restapi.client.UnauthorizedException;
import org.ctoolkit.restapi.client.googleapis.GoogleApiProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleApiSheetsModule
extends AbstractModule {
    public static final String API_PREFIX = "sheets";
    private static final Logger logger = LoggerFactory.getLogger(GoogleApiSheetsModule.class);
    private ApiToken<? extends HttpRequestInitializer> initialized;

    protected void configure() {
    }

    @Provides
    @Singleton
    Sheets provideSheets(GoogleApiProxyFactory factory) {
        Sheets.Builder builder;
        Set scopes = SheetsScopes.all();
        try {
            this.initialized = factory.authorize((Collection)scopes, null, API_PREFIX);
            HttpRequestInitializer credential = (HttpRequestInitializer)this.initialized.getCredential();
            builder = new Sheets.Builder(factory.getHttpTransport(), factory.getJsonFactory(), credential);
            builder.setApplicationName(factory.getApplicationName(API_PREFIX));
        }
        catch (GeneralSecurityException e) {
            logger.error("Failed. Scopes: " + scopes.toString() + " Application name: " + factory.getApplicationName(API_PREFIX) + " Service account: " + factory.getServiceAccountEmail(API_PREFIX), (Throwable)e);
            throw new UnauthorizedException(e.getMessage());
        }
        catch (IOException e) {
            logger.error("Failed. Scopes: " + scopes.toString() + " Application name: " + factory.getApplicationName(API_PREFIX) + " Service account: " + factory.getServiceAccountEmail(API_PREFIX), (Throwable)e);
            throw new ServiceUnavailableException(e.getMessage());
        }
        return builder.build();
    }

    @Provides
    @AccessToken(apiName="sheets")
    ApiToken.Data provideSheetsTokenData(Sheets client) {
        this.initialized.setServiceUrl(client.getBaseUrl());
        return this.initialized.getTokenData();
    }
}

