/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.api.client.http.HttpRequest;
import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.ctoolkit.restapi.client.adapter.BeforeRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OboIdentityTokenSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(OboIdentityTokenSubscriber.class);
    private final Provider<HttpServletRequest> provider;

    @Inject
    public OboIdentityTokenSubscriber(EventBus eventBus, Provider<HttpServletRequest> provider) {
        eventBus.register((Object)this);
        this.provider = provider;
    }

    @Subscribe
    public void onBeforeRequestEvent(BeforeRequestEvent event) {
        HttpRequest request = event.getRequest();
        HttpServletRequest originServletRequest = (HttpServletRequest)this.provider.get();
        Cookie[] cookies = originServletRequest.getCookies();
        if (cookies == null) {
            return;
        }
        String token = null;
        for (Cookie cookie : cookies) {
            if (!"gtoken".equals(cookie.getName())) continue;
            token = cookie.getValue();
        }
        if (Strings.isNullOrEmpty(token)) {
            logger.info("No token to forward.");
        } else {
            request.getHeaders().put("ctoolkit-obo-token", token);
        }
    }
}

