/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.api.client.http.HttpResponseException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import org.ctoolkit.restapi.client.ClientErrorException;
import org.ctoolkit.restapi.client.HttpFailureException;
import org.ctoolkit.restapi.client.Identifier;
import org.ctoolkit.restapi.client.MediaRequest;
import org.ctoolkit.restapi.client.NotFoundException;
import org.ctoolkit.restapi.client.Patch;
import org.ctoolkit.restapi.client.RemoteServerErrorException;
import org.ctoolkit.restapi.client.ResourceFacade;
import org.ctoolkit.restapi.client.SingleRequest;
import org.ctoolkit.restapi.client.UnauthorizedException;
import org.ctoolkit.restapi.client.adaptee.DeleteExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.GetExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.InsertExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.ListExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.MediaProvider;
import org.ctoolkit.restapi.client.adaptee.NewExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.PatchAdaptee;
import org.ctoolkit.restapi.client.adaptee.PatchExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.UpdateExecutorAdaptee;
import org.ctoolkit.restapi.client.adapter.DeleteRequest;
import org.ctoolkit.restapi.client.adapter.GetRequest;
import org.ctoolkit.restapi.client.adapter.InputStreamMediaRequest;
import org.ctoolkit.restapi.client.adapter.InsertRequest;
import org.ctoolkit.restapi.client.adapter.ListRequest;
import org.ctoolkit.restapi.client.adapter.NewInstanceRequest;
import org.ctoolkit.restapi.client.adapter.PatchRequest;
import org.ctoolkit.restapi.client.adapter.PatchRequestImpl;
import org.ctoolkit.restapi.client.adapter.ResourceProviderInjector;
import org.ctoolkit.restapi.client.adapter.UpdateRequest;
import org.ctoolkit.restapi.client.provider.LocalResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFacadeAdapter
implements ResourceFacade {
    private static final Logger logger = LoggerFactory.getLogger(ResourceFacadeAdapter.class);
    private final MapperFacade mapper;
    private final MapperFactory factory;
    private final ResourceProviderInjector injector;

    @Inject
    public ResourceFacadeAdapter(MapperFacade mapper, MapperFactory factory, ResourceProviderInjector injector) {
        this.mapper = mapper;
        this.factory = factory;
        this.injector = injector;
    }

    public <T> SingleRequest<T> newInstance(@Nonnull Class<T> resource) {
        return this.newInstance(resource, null, null);
    }

    public <T> SingleRequest<T> newInstance(@Nonnull Class<T> resource, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        Object remoteRequest;
        Preconditions.checkNotNull(resource);
        NewExecutorAdaptee adaptee = this.adaptee(NewExecutorAdaptee.class, resource);
        try {
            remoteRequest = adaptee.prepareNew(resource.getSimpleName(), parameters, locale);
        }
        catch (IOException e) {
            throw new ClientErrorException(400, e.getMessage());
        }
        return new NewInstanceRequest<T>(resource, this, adaptee, remoteRequest);
    }

    public <T> MediaRequest<T> media(@Nonnull T resource) {
        Preconditions.checkNotNull(resource);
        return new InputStreamMediaRequest<T>(this, resource);
    }

    <R> R callbackNewInstance(@Nonnull NewExecutorAdaptee adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        Object remoteInstance;
        Preconditions.checkNotNull((Object)adaptee);
        Preconditions.checkNotNull((Object)remoteRequest);
        Preconditions.checkNotNull(responseType);
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        try {
            remoteInstance = adaptee.executeNew(remoteRequest, parameters, locale);
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, responseType, null);
        }
        if (remoteInstance.getClass() == responseType) {
            return (R)remoteInstance;
        }
        return (R)this.mapper.map(remoteInstance, responseType);
    }

    public <T> SingleRequest<T> get(@Nonnull Class<T> resource, @Nonnull Identifier identifier) {
        Object remoteRequest;
        Preconditions.checkNotNull(resource);
        Preconditions.checkNotNull((Object)identifier);
        GetExecutorAdaptee adaptee = this.adaptee(GetExecutorAdaptee.class, resource);
        try {
            remoteRequest = adaptee.prepareGet(identifier);
        }
        catch (IOException e) {
            throw new ClientErrorException(400, e.getMessage());
        }
        return new GetRequest<T>(resource, identifier, this, adaptee, remoteRequest);
    }

    public <T> SingleRequest<T> get(@Nonnull Class<T> resource, @Nonnull String identifier) {
        return this.get(resource, new Identifier(identifier));
    }

    public <T> SingleRequest<T> get(@Nonnull Class<T> resource, @Nonnull Long identifier) {
        return this.get(resource, new Identifier(identifier));
    }

    <R> R callbackExecuteGet(@Nonnull GetExecutorAdaptee adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nonnull Object identifier, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        Preconditions.checkNotNull(responseType);
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        LocalResourceProvider<R> provider = this.injector.getExistingResourceProvider(responseType);
        Object response = null;
        boolean requestForPersist = false;
        if (provider != null) {
            response = provider.get(identifier, parameters, locale, null);
            boolean bl = requestForPersist = response == null;
        }
        if (response == null) {
            Object remoteObject;
            try {
                remoteObject = adaptee.executeGet(remoteRequest, parameters, locale);
            }
            catch (IOException e) {
                RuntimeException exception = this.prepareRetrievalException(e, responseType, identifier);
                if (exception == null) {
                    return null;
                }
                throw exception;
            }
            response = remoteObject.getClass() == responseType ? remoteObject : this.mapper.map(remoteObject, responseType);
        }
        if (requestForPersist && response != null) {
            provider.persist(response, identifier, parameters, locale);
        }
        return (R)response;
    }

    public <T> ListRequest<T> list(@Nonnull Class<T> resource) {
        return this.list((Class)resource, (Identifier)null);
    }

    public <T> ListRequest<T> list(@Nonnull Class<T> resource, @Nullable Identifier parent) {
        Object remoteRequest;
        Preconditions.checkNotNull(resource);
        ListExecutorAdaptee adaptee = this.adaptee(ListExecutorAdaptee.class, resource);
        try {
            remoteRequest = adaptee.prepareList(parent);
        }
        catch (IOException e) {
            throw new ClientErrorException(400, e.getMessage());
        }
        return new ListRequest<T>(resource, this, adaptee, remoteRequest);
    }

    <R> List<R> callbackExecuteList(@Nonnull ListExecutorAdaptee adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nullable Map<String, Object> criteria, @Nullable Locale locale, int start, int length) {
        Preconditions.checkNotNull(responseType);
        if (criteria == null) {
            criteria = new HashMap<String, Object>();
        }
        LocalResourceProvider<R> provider = this.injector.getExistingResourceProvider(responseType);
        List response = null;
        boolean requestForPersist = false;
        if (provider != null) {
            response = provider.list(criteria, locale, null);
            boolean bl = requestForPersist = response == null;
        }
        if (response == null) {
            List remoteList;
            try {
                remoteList = adaptee.executeList(remoteRequest, criteria, locale, start, length);
            }
            catch (IOException e) {
                RuntimeException exception = this.prepareRetrievalException(e, responseType, null);
                if (exception == null) {
                    remoteList = null;
                }
                throw exception;
            }
            response = remoteList == null || remoteList.isEmpty() ? Lists.newArrayList() : (remoteList.get(0).getClass() == responseType ? remoteList : this.mapper.mapAsList((Iterable)remoteList, responseType));
        }
        if (requestForPersist && response != null && !response.isEmpty()) {
            provider.persistList(response, criteria, locale);
        }
        return response;
    }

    public <T> SingleRequest<T> insert(@Nonnull T resource) {
        return this.insert(resource, null);
    }

    public <T> SingleRequest<T> insert(@Nonnull T resource, @Nullable Identifier parentKey) {
        return this.internalInsert(resource, parentKey, null);
    }

    <T> SingleRequest<T> internalInsert(@Nonnull T resource, @Nullable Identifier parentKey, @Nullable MediaProvider<?> provider) {
        Object remoteRequest;
        Preconditions.checkNotNull(resource);
        Class<?> remoteResource = this.evaluateRemoteResource(resource.getClass());
        Object source = resource.getClass() == remoteResource ? resource : this.mapper.map(resource, remoteResource);
        InsertExecutorAdaptee adaptee = this.adaptee(InsertExecutorAdaptee.class, resource.getClass());
        try {
            remoteRequest = adaptee.prepareInsert(source, parentKey, provider);
        }
        catch (IOException e) {
            throw new ClientErrorException(400, e.getMessage());
        }
        Class<?> resourceClass = resource.getClass();
        return new InsertRequest(resourceClass, parentKey, this, adaptee, remoteRequest);
    }

    <R> R callbackExecuteInsert(@Nonnull InsertExecutorAdaptee adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nullable Object parentKey, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        Object source;
        Preconditions.checkNotNull((Object)adaptee);
        Preconditions.checkNotNull((Object)remoteRequest);
        Preconditions.checkNotNull(responseType);
        try {
            source = adaptee.executeInsert(remoteRequest, parameters, locale);
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, responseType, parentKey);
        }
        if (source == null) {
            return null;
        }
        if (source.getClass() == responseType) {
            return (R)source;
        }
        return (R)this.mapper.map(source, responseType);
    }

    public <T> SingleRequest<T> update(@Nonnull T resource, @Nonnull Identifier identifier) {
        return this.internalUpdate(resource, identifier, null);
    }

    public <T> SingleRequest<T> update(@Nonnull T resource, @Nonnull String identifier) {
        return this.update(resource, new Identifier(identifier));
    }

    public <T> SingleRequest<T> update(@Nonnull T resource, @Nonnull Long identifier) {
        return this.update(resource, new Identifier(identifier));
    }

    <T> SingleRequest<T> internalUpdate(@Nonnull T resource, @Nonnull Identifier identifier, @Nullable MediaProvider<?> provider) {
        Object remoteRequest;
        Preconditions.checkNotNull(resource);
        Preconditions.checkNotNull((Object)identifier);
        Class<?> remoteResource = this.evaluateRemoteResource(resource.getClass());
        Object source = resource.getClass() == remoteResource ? resource : this.mapper.map(resource, remoteResource);
        UpdateExecutorAdaptee adaptee = this.adaptee(UpdateExecutorAdaptee.class, resource.getClass());
        try {
            remoteRequest = adaptee.prepareUpdate(source, identifier, provider);
        }
        catch (IOException e) {
            throw new ClientErrorException(400, e.getMessage());
        }
        Class<?> resourceClass = resource.getClass();
        return new UpdateRequest(resourceClass, identifier, this, adaptee, remoteRequest);
    }

    <R> R callbackExecuteUpdate(@Nonnull UpdateExecutorAdaptee adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nonnull Object identifier, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        Object source;
        Preconditions.checkNotNull((Object)adaptee);
        Preconditions.checkNotNull((Object)remoteRequest);
        Preconditions.checkNotNull(responseType);
        Preconditions.checkNotNull((Object)identifier);
        try {
            source = adaptee.executeUpdate(remoteRequest, parameters, locale);
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, responseType, identifier);
        }
        if (source == null) {
            return null;
        }
        if (source.getClass() == responseType) {
            return (R)source;
        }
        return (R)this.mapper.map(source, responseType);
    }

    public <T> SingleRequest<T> patch(@Nonnull Patch<T> resource, @Nonnull Identifier identifier) {
        Object remoteRequest;
        Preconditions.checkNotNull(resource);
        Preconditions.checkNotNull((Object)identifier);
        Class<?> remoteResource = this.evaluateRemoteResource(resource.getClass());
        Object source = resource.getClass() == remoteResource ? resource : this.mapper.map(resource, remoteResource);
        String alias = remoteResource.getSimpleName();
        Class responseType = resource.type();
        if (responseType == null) {
            throw new NotFoundException("The Patch.type() must return a non null value.");
        }
        PatchExecutorAdaptee adaptee = this.adaptee(PatchExecutorAdaptee.class, responseType);
        try {
            remoteRequest = adaptee.preparePatch(source, identifier, alias);
        }
        catch (IOException e) {
            throw new ClientErrorException(400, e.getMessage());
        }
        return new PatchRequest(responseType, identifier, this, adaptee, remoteRequest);
    }

    <R> R callbackExecutePatch(@Nonnull PatchExecutorAdaptee adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nonnull Object identifier, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        Object source;
        Preconditions.checkNotNull(responseType);
        Preconditions.checkNotNull((Object)identifier);
        try {
            source = adaptee.executePatch(remoteRequest, parameters, locale);
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, responseType, identifier);
        }
        if (source == null) {
            return null;
        }
        if (source.getClass() == responseType) {
            return (R)source;
        }
        return (R)this.mapper.map(source, responseType);
    }

    public <S> org.ctoolkit.restapi.client.PatchRequest<S> patch(@Nonnull Class<S> resource) {
        PatchAdaptee adaptee = this.adaptee(PatchAdaptee.class, resource);
        return new PatchRequestImpl(this, adaptee);
    }

    <S> S callbackPatchAdaptee(@Nonnull PatchAdaptee<S> adaptee, Object resource, Identifier identifier) {
        Object remoteRequest;
        try {
            remoteRequest = adaptee.preparePatch(resource, identifier);
        }
        catch (IOException e) {
            throw new ClientErrorException(400, e.getMessage());
        }
        return (S)remoteRequest;
    }

    public <T> SingleRequest<T> delete(@Nonnull Class<T> resource, @Nonnull Identifier identifier) {
        Object remoteRequest;
        Preconditions.checkNotNull(resource);
        Preconditions.checkNotNull((Object)identifier);
        DeleteExecutorAdaptee adaptee = this.adaptee(DeleteExecutorAdaptee.class, resource);
        try {
            remoteRequest = adaptee.prepareDelete(identifier);
        }
        catch (IOException e) {
            throw new ClientErrorException(400, e.getMessage());
        }
        return new DeleteRequest(resource, identifier, this, adaptee, remoteRequest);
    }

    public <T> SingleRequest<T> delete(@Nonnull Class<T> resource, @Nonnull String identifier) {
        return this.delete(resource, new Identifier(identifier));
    }

    public <T> SingleRequest<T> delete(@Nonnull Class<T> resource, @Nonnull Long identifier) {
        return this.delete(resource, new Identifier(identifier));
    }

    Void callbackExecuteDelete(@Nonnull DeleteExecutorAdaptee adaptee, @Nonnull Object remoteRequest, @Nonnull Class resource, @Nonnull Object identifier, @Nullable Locale locale) {
        Preconditions.checkNotNull((Object)identifier);
        try {
            adaptee.executeDelete(remoteRequest, locale);
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, resource, identifier);
        }
        return null;
    }

    private RuntimeException prepareRetrievalException(IOException e, Class<?> resource, @Nullable Object identifier) {
        return this.prepareException(e, resource, identifier, false);
    }

    private RuntimeException prepareUpdateException(IOException e, Class<?> resource, @Nullable Object identifier) {
        return this.prepareException(e, resource, identifier, true);
    }

    private RuntimeException prepareException(IOException e, Class<?> resource, @Nullable Object identifier, boolean update) {
        int statusCode = -1;
        String statusMessage = null;
        if (e instanceof HttpResponseException) {
            statusCode = ((HttpResponseException)e).getStatusCode();
            statusMessage = ((HttpResponseException)e).getStatusMessage();
        }
        logger.warn("Resource " + resource.getName() + ", identifier: " + identifier, (Throwable)e);
        Object toBeThrown = 400 == statusCode ? new ClientErrorException(statusCode, statusMessage) : (401 == statusCode ? new UnauthorizedException(statusMessage) : (403 == statusCode ? new ClientErrorException(statusCode, statusMessage) : (404 == statusCode && update ? new NotFoundException(statusMessage) : (404 == statusCode ? new NotFoundException(statusMessage) : (409 == statusCode ? new ClientErrorException(statusCode, statusMessage) : (400 < statusCode && statusCode < 499 ? new ClientErrorException(statusCode, statusMessage) : (500 == statusCode ? new RemoteServerErrorException(statusCode, statusMessage) : (503 == statusCode ? new RemoteServerErrorException(statusCode, statusMessage) : (statusCode > -1 ? new HttpFailureException(statusCode, statusMessage) : new RuntimeException(statusMessage))))))))));
        return toBeThrown;
    }

    private Class<?> evaluateRemoteResource(Class resource) {
        Set types = this.factory.lookupMappedClasses(TypeFactory.valueOf((Class)resource));
        Iterator iterator = types.iterator();
        Class remoteResource = iterator.hasNext() ? ((Type)iterator.next()).getRawType() : resource;
        return remoteResource;
    }

    private <A> A adaptee(Class<A> adapteeType, Class<?> resource) {
        Class<?> remoteResource = this.evaluateRemoteResource(resource);
        A adaptee = this.injector.getExecutorAdaptee(adapteeType, remoteResource);
        if (adaptee == null && remoteResource == resource) {
            String msg = "Missing binding between adaptee and resource: " + adapteeType.getSimpleName() + "<" + resource.getName() + ">";
            throw new NotFoundException(msg);
        }
        if (adaptee == null) {
            String msg = "Missing binding between adaptee and remote resource: " + adapteeType.getSimpleName() + "<" + remoteResource.getName() + ">. The remote resource " + remoteResource.getName() + " is being mapped to " + resource.getName() + ".";
            throw new NotFoundException(msg);
        }
        return adaptee;
    }
}

