/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.ctoolkit.restapi.client.adaptee.MediaProvider;

public class AbstractGoogleClientAdaptee<C> {
    private final Provider<C> client;

    public AbstractGoogleClientAdaptee(Provider<C> client) {
        this.client = client;
    }

    protected final C client() {
        return (C)this.client.get();
    }

    protected void fill(@Nonnull Object remoteRequest, @Nullable Map<String, Object> parameters) {
        Preconditions.checkNotNull((Object)remoteRequest);
        AbstractGoogleJsonClientRequest request = (AbstractGoogleJsonClientRequest)remoteRequest;
        if (parameters != null) {
            for (Map.Entry<String, Object> entrySet : parameters.entrySet()) {
                Object value = entrySet.getValue();
                if (value instanceof Enum) {
                    value = ((Enum)value).name();
                }
                request.set(entrySet.getKey(), value);
            }
        }
    }

    protected final AbstractInputStreamContent media(@Nullable MediaProvider provider) {
        if (provider == null) {
            return null;
        }
        return (AbstractInputStreamContent)provider.getMedia();
    }

    public Object execute(@Nonnull Object request, @Nullable Map<String, Object> parameters) throws IOException {
        Preconditions.checkNotNull((Object)request);
        this.fill(request, parameters);
        return ((AbstractGoogleJsonClientRequest)request).execute();
    }
}

