/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.AuthRequest;
import org.ctoolkit.restapi.client.Request;
import org.ctoolkit.restapi.client.RequestCredential;
import org.ctoolkit.restapi.client.adapter.GoogleRequestHeaders;
import org.ctoolkit.restapi.client.provider.TokenProvider;

class AuthRequestImpl<T>
implements AuthRequest<T> {
    private final Request<T> request;
    private GoogleRequestHeaders filler;

    AuthRequestImpl(Request<T> request, GoogleRequestHeaders filler) {
        this.request = (Request)Preconditions.checkNotNull(request);
        this.filler = (GoogleRequestHeaders)Preconditions.checkNotNull((Object)filler);
    }

    public Request<T> bearer() {
        this.filler.setAuthScheme(AuthRequest.AuthScheme.BEARER);
        return this;
    }

    public Request<T> oauth() {
        this.filler.setAuthScheme(AuthRequest.AuthScheme.OAUTH);
        return this;
    }

    public Request<T> onBehalfOf(@Nonnull Object of) {
        this.filler.setOnBehalfOf(of);
        return this;
    }

    public T finish() {
        return (T)this.request.finish();
    }

    public T finish(@Nonnull RequestCredential credential) {
        return (T)this.request.finish(credential);
    }

    public T finish(@Nullable Map<String, Object> parameters) {
        return (T)this.request.finish(parameters);
    }

    public T finish(@Nullable Locale locale) {
        return (T)this.request.finish(locale);
    }

    public T finish(@Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        return (T)this.request.finish(parameters, locale);
    }

    public Request<T> configWith(@Nonnull Properties properties) {
        return this.request.configWith(properties);
    }

    public Request<T> forLang(@Nonnull Locale locale) {
        return this.request.forLang(locale);
    }

    public Request<T> add(@Nonnull String name, @Nonnull Object value) {
        return this.request.add(name, value);
    }

    public Request<T> add(@Nonnull String name, @Nonnull String value) {
        return this.request.add(name, value);
    }

    public Request<T> addHeader(@Nonnull String header, @Nonnull String value) {
        return this.request.addHeader(header, value);
    }

    public AuthRequest<T> authBy(@Nonnull String token) {
        return this.request.authBy(token);
    }

    public AuthRequest<T> authBy(@Nonnull TokenProvider<?> provider) {
        return this.request.authBy(provider);
    }
}

