/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.ctoolkit.restapi.client.ServiceUnavailableException;
import org.ctoolkit.restapi.client.UnauthorizedException;
import org.ctoolkit.restapi.client.adapter.ClientApi;
import org.ctoolkit.restapi.client.adapter.GoogleApiProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientApiProvider<C>
implements ClientApi<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientApiProvider.class);
    private final GoogleApiProxyFactory factory;
    private ThreadLocal<C> threadLocal;

    public ClientApiProvider(@Nonnull GoogleApiProxyFactory factory) {
        Preconditions.checkNotNull((Object)this.api(), (Object)"API name cannot be null");
        this.factory = (GoogleApiProxyFactory)Preconditions.checkNotNull((Object)factory, (Object)"API factory cannot be null");
    }

    @Inject
    void init() {
        AtomicReference<C> defaultClient = new AtomicReference<C>();
        this.threadLocal = ThreadLocal.withInitial(defaultClient::get);
        defaultClient.set(this.init(this.getScopes(this.api()), null, false));
    }

    public C get() {
        return this.threadLocal.get();
    }

    private Collection<String> getScopes(@Nullable String api) {
        Collection<String> scopes = this.factory.getScopes(api);
        if (scopes == null || scopes.isEmpty()) {
            scopes = this.defaultScopes();
        }
        return scopes;
    }

    @Override
    public C init(@Nullable Collection<String> scopes, @Nullable String userEmail) {
        return this.init(scopes == null ? this.getScopes(this.api()) : scopes, userEmail, true);
    }

    private C init(@Nonnull Collection<String> scopes, @Nullable String userEmail, boolean updateLocal) {
        String prefix = (String)Preconditions.checkNotNull((Object)this.api(), (Object)"API short name is mandatory");
        String applicationName = this.factory.getApplicationName(prefix);
        String serviceAccountEmail = this.factory.getServiceAccountEmail(prefix);
        try {
            HttpRequestInitializer credential = this.factory.authorize(scopes, userEmail, prefix);
            C client = this.build(this.factory, this.factory.getHttpTransport(), this.factory.getJsonFactory(), credential, prefix);
            if (updateLocal) {
                this.threadLocal.set(client);
            }
            return client;
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Failed. Scopes: " + scopes.toString() + " Application name: " + applicationName + " Service account: " + serviceAccountEmail, (Throwable)e);
            throw new UnauthorizedException(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error("Failed. Scopes: " + scopes.toString() + " Application name: " + applicationName + " Service account: " + serviceAccountEmail, (Throwable)e);
            throw new ServiceUnavailableException(e.getMessage());
        }
    }

    protected abstract Collection<String> defaultScopes();

    protected abstract String api();

    protected abstract C build(@Nonnull GoogleApiProxyFactory var1, @Nonnull HttpTransport var2, @Nonnull JsonFactory var3, @Nonnull HttpRequestInitializer var4, @Nonnull String var5);
}

