/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.AuthRequest;
import org.ctoolkit.restapi.client.PayloadRequest;
import org.ctoolkit.restapi.client.Request;
import org.ctoolkit.restapi.client.RequestCredential;
import org.ctoolkit.restapi.client.adaptee.DeleteExecutorAdaptee;
import org.ctoolkit.restapi.client.adapter.AuthRequestImpl;
import org.ctoolkit.restapi.client.adapter.GoogleRequestHeaders;
import org.ctoolkit.restapi.client.adapter.RestFacadeAdapter;
import org.ctoolkit.restapi.client.provider.TokenProvider;

class DeleteRequest<T>
implements PayloadRequest<T> {
    private final Class<T> resource;
    private final Object identifier;
    private final RestFacadeAdapter adapter;
    private final DeleteExecutorAdaptee<?> adaptee;
    private final Object remoteRequest;
    private Map<String, Object> params;
    private Locale withLocale;
    private GoogleRequestHeaders filler;

    DeleteRequest(@Nonnull Object identifier, @Nonnull RestFacadeAdapter adapter, @Nonnull DeleteExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest) {
        this(null, identifier, adapter, adaptee, remoteRequest);
    }

    private DeleteRequest(@Nullable Class<T> resource, @Nonnull Object identifier, @Nonnull RestFacadeAdapter adapter, @Nonnull DeleteExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest) {
        this.resource = resource;
        this.identifier = Preconditions.checkNotNull((Object)identifier);
        this.adapter = (RestFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.adaptee = (DeleteExecutorAdaptee)Preconditions.checkNotNull(adaptee);
        this.remoteRequest = Preconditions.checkNotNull((Object)remoteRequest);
        this.params = new HashMap<String, Object>();
        this.filler = new GoogleRequestHeaders(remoteRequest);
    }

    public T finish() {
        return this.finish(null, this.withLocale);
    }

    public T finish(@Nonnull RequestCredential credential) {
        Preconditions.checkNotNull((Object)credential);
        credential.populate(this.params);
        return this.finish();
    }

    public T finish(@Nullable Map<String, Object> parameters) {
        return this.finish(parameters, this.withLocale);
    }

    public T finish(@Nullable Locale locale) {
        return this.finish(null, locale);
    }

    public T finish(@Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        if (parameters != null) {
            this.params.putAll(parameters);
        }
        this.filler.acceptLanguage(locale);
        return this.adapter.callbackExecuteDelete(this.adaptee, this.remoteRequest, this.identifier, this.filler, this.resource, this.params, locale);
    }

    public Request<T> configWith(@Nonnull Properties properties) {
        Preconditions.checkNotNull((Object)properties);
        RequestCredential.populate((Properties)properties, this.params);
        return this;
    }

    public Request<T> forLang(@Nonnull Locale locale) {
        this.withLocale = (Locale)Preconditions.checkNotNull((Object)locale);
        return this;
    }

    public Request<T> add(@Nonnull String name, @Nonnull Object value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.params.put(name, value);
        return this;
    }

    public Request<T> add(@Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.params.put(name, value);
        return this;
    }

    public Request<T> addHeader(@Nonnull String header, @Nonnull String value) {
        Preconditions.checkNotNull((Object)header);
        Preconditions.checkNotNull((Object)value);
        this.filler.addHeader(header, value);
        return this;
    }

    public Request<T> onBehalfOf(@Nonnull Object of) {
        this.filler.setOnBehalfOf(of);
        return this;
    }

    public AuthRequest<T> authBy(@Nonnull String token) {
        Preconditions.checkNotNull((Object)token, (Object)"Authorization token expected to be not null");
        this.filler.setTokenCreator(() -> token);
        return new AuthRequestImpl(this, this.filler);
    }

    public AuthRequest<T> authBy(@Nonnull TokenProvider<?> provider) {
        this.filler.setTokenCreator((TokenProvider)Preconditions.checkNotNull(provider, (Object)"Token provider can't be null"));
        return new AuthRequestImpl(this, this.filler);
    }

    public <U> U underlying(Class<U> type) {
        return (U)this.remoteRequest;
    }

    public <R> Request<R> answerBy(@Nonnull Class<R> type) {
        Preconditions.checkNotNull(type);
        return new DeleteRequest<R>(type, this.identifier, this.adapter, this.adaptee, this.remoteRequest);
    }

    public <R> R finish(@Nonnull Class<R> type) {
        return (R)this.answerBy(type).finish();
    }
}

