/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.AuthRequest;
import org.ctoolkit.restapi.client.DownloadRequest;
import org.ctoolkit.restapi.client.Identifier;
import org.ctoolkit.restapi.client.Request;
import org.ctoolkit.restapi.client.RequestCredential;
import org.ctoolkit.restapi.client.adaptee.DownloadExecutorAdaptee;
import org.ctoolkit.restapi.client.adapter.AuthRequestImpl;
import org.ctoolkit.restapi.client.adapter.DownloadResponseInterceptor;
import org.ctoolkit.restapi.client.adapter.GoogleRequestHeaders;
import org.ctoolkit.restapi.client.adapter.RestFacadeAdapter;
import org.ctoolkit.restapi.client.provider.TokenProvider;

class DownloadRequestImpl
implements DownloadRequest {
    private final RestFacadeAdapter adapter;
    private final DownloadExecutorAdaptee<?> adaptee;
    private final MediaHttpDownloader downloader;
    private final Class<?> resource;
    private final Identifier identifier;
    private final OutputStream output;
    private final DownloadResponseInterceptor interceptor;
    private Map<String, Object> params;
    private Locale withLocale;
    private GoogleRequestHeaders filler;

    DownloadRequestImpl(@Nonnull RestFacadeAdapter adapter, @Nonnull DownloadExecutorAdaptee<?> adaptee, @Nonnull MediaHttpDownloader downloader, @Nonnull Class<?> resource, @Nonnull Identifier identifier, @Nonnull OutputStream output, @Nonnull DownloadResponseInterceptor interceptor, @Nullable String type) {
        this.adapter = (RestFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.adaptee = (DownloadExecutorAdaptee)Preconditions.checkNotNull(adaptee);
        this.downloader = (MediaHttpDownloader)Preconditions.checkNotNull((Object)downloader);
        this.resource = (Class)Preconditions.checkNotNull(resource);
        this.identifier = (Identifier)Preconditions.checkNotNull((Object)identifier);
        this.output = (OutputStream)Preconditions.checkNotNull((Object)output);
        this.interceptor = (DownloadResponseInterceptor)Preconditions.checkNotNull((Object)interceptor);
        this.params = new HashMap<String, Object>();
        this.filler = new GoogleRequestHeaders();
        this.filler.contentType(type);
    }

    public Map<String, Object> finish() {
        return this.finish((Map)null, this.withLocale);
    }

    public Map<String, Object> finish(@Nonnull RequestCredential credential) {
        Preconditions.checkNotNull((Object)credential);
        credential.populate(this.params);
        return this.finish();
    }

    public Map<String, Object> finish(@Nullable Map<String, Object> parameters) {
        return this.finish((Map)parameters, this.withLocale);
    }

    public Map<String, Object> finish(@Nullable Locale locale) {
        return this.finish((Map)null, locale);
    }

    public Map<String, Object> finish(@Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        if (parameters != null) {
            this.params.putAll(parameters);
        }
        this.filler.acceptLanguage(locale);
        this.filler.fillInCredential(this.params);
        return this.adapter.executeDownload(this.downloader, this.adaptee, this.resource, this.identifier, this.output, this.interceptor, this.filler, this.params, locale);
    }

    public Request<Map<String, Object>> configWith(@Nonnull Properties properties) {
        Preconditions.checkNotNull((Object)properties);
        RequestCredential.populate((Properties)properties, this.params);
        return this;
    }

    public Request<Map<String, Object>> forLang(@Nonnull Locale locale) {
        this.withLocale = (Locale)Preconditions.checkNotNull((Object)locale);
        return this;
    }

    public Request<Map<String, Object>> add(@Nonnull String name, @Nonnull Object value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.params.put(name, value);
        return this;
    }

    public Request<Map<String, Object>> add(@Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.params.put(name, value);
        return this;
    }

    public Request<Map<String, Object>> addHeader(@Nonnull String header, @Nonnull String value) {
        Preconditions.checkNotNull((Object)header);
        Preconditions.checkNotNull((Object)value);
        this.filler.addHeader(header, value);
        return this;
    }

    public Request<Map<String, Object>> onBehalfOf(@Nonnull Object of) {
        this.filler.setOnBehalfOf(of);
        return this;
    }

    public AuthRequest<Map<String, Object>> authBy(@Nonnull String token) {
        Preconditions.checkNotNull((Object)token, (Object)"Authorization token expected to be not null");
        this.filler.setTokenCreator(() -> token);
        return new AuthRequestImpl<Map<String, Object>>((Request<Map<String, Object>>)this, this.filler);
    }

    public AuthRequest<Map<String, Object>> authBy(@Nonnull TokenProvider<?> provider) {
        this.filler.setTokenCreator((TokenProvider)Preconditions.checkNotNull(provider, (Object)"Token provider can't be null"));
        return new AuthRequestImpl<Map<String, Object>>((Request<Map<String, Object>>)this, this.filler);
    }
}

