/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.AuthRequest;
import org.ctoolkit.restapi.client.Identifier;
import org.ctoolkit.restapi.client.Request;
import org.ctoolkit.restapi.client.RequestCredential;
import org.ctoolkit.restapi.client.RetrievalRequest;
import org.ctoolkit.restapi.client.adaptee.GetExecutorAdaptee;
import org.ctoolkit.restapi.client.adapter.AuthRequestImpl;
import org.ctoolkit.restapi.client.adapter.GoogleRequestHeaders;
import org.ctoolkit.restapi.client.adapter.RestFacadeAdapter;
import org.ctoolkit.restapi.client.provider.TokenProvider;

class GetRequest<T>
implements RetrievalRequest<T> {
    private final Class<T> resource;
    private final Identifier identifier;
    private final RestFacadeAdapter adapter;
    private final GetExecutorAdaptee<?> adaptee;
    private final Object remoteRequest;
    private Map<String, Object> params;
    private Locale withLocale;
    private GoogleRequestHeaders filler;

    GetRequest(@Nonnull Class<T> resource, @Nonnull Identifier identifier, @Nonnull RestFacadeAdapter adapter, @Nonnull GetExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest) {
        this.resource = (Class)Preconditions.checkNotNull(resource);
        this.identifier = (Identifier)Preconditions.checkNotNull((Object)identifier);
        this.adapter = (RestFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.adaptee = (GetExecutorAdaptee)Preconditions.checkNotNull(adaptee);
        this.remoteRequest = Preconditions.checkNotNull((Object)remoteRequest);
        this.params = new HashMap<String, Object>();
        this.filler = new GoogleRequestHeaders(remoteRequest);
    }

    public <U> U underlying(Class<U> type) {
        return (U)this.remoteRequest;
    }

    public T finish() {
        return this.finish(null, this.withLocale);
    }

    public T finish(@Nonnull RequestCredential credential) {
        Preconditions.checkNotNull((Object)credential);
        credential.populate(this.params);
        return this.finish();
    }

    public T finish(@Nullable Map<String, Object> criteria) {
        return this.finish(criteria, this.withLocale);
    }

    public T finish(@Nullable Locale locale) {
        return this.finish(null, locale);
    }

    public T finish(@Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        if (parameters != null) {
            this.params.putAll(parameters);
        }
        this.filler.acceptLanguage(locale);
        return this.adapter.callbackExecuteGet(this.adaptee, this.remoteRequest, this.resource, this.identifier, this.filler, this.params, locale);
    }

    public Request<T> configWith(@Nonnull Properties properties) {
        Preconditions.checkNotNull((Object)properties);
        RequestCredential.populate((Properties)properties, this.params);
        return this;
    }

    public Request<T> forLang(@Nonnull Locale locale) {
        this.withLocale = (Locale)Preconditions.checkNotNull((Object)locale);
        return this;
    }

    public Request<T> add(@Nonnull String name, @Nonnull Object value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.params.put(name, value);
        return this;
    }

    public Request<T> add(@Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.params.put(name, value);
        return this;
    }

    public Request<T> addHeader(@Nonnull String header, @Nonnull String value) {
        Preconditions.checkNotNull((Object)header);
        Preconditions.checkNotNull((Object)value);
        this.filler.addHeader(header, value);
        return this;
    }

    public Request<T> onBehalfOf(@Nonnull Object of) {
        this.filler.setOnBehalfOf(of);
        return this;
    }

    public AuthRequest<T> authBy(@Nonnull String token) {
        Preconditions.checkNotNull((Object)token, (Object)"Authorization token expected to be not null");
        this.filler.setTokenCreator(() -> token);
        return new AuthRequestImpl(this, this.filler);
    }

    public AuthRequest<T> authBy(@Nonnull TokenProvider<?> provider) {
        this.filler.setTokenCreator((TokenProvider)Preconditions.checkNotNull(provider, (Object)"Token provider can't be null"));
        return new AuthRequestImpl(this, this.filler);
    }
}

