/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.ApiCredential;
import org.ctoolkit.restapi.client.adapter.BeforeRequestEvent;
import org.ctoolkit.restapi.client.provider.AuthKeyProvider;

public abstract class GoogleApiProxyFactory {
    protected final EventBus eventBus;
    private final Map<String, String> credential;
    private HttpTransport httpTransport;
    private JsonFactory jsonFactory;
    private AuthKeyProvider keyProvider;

    protected GoogleApiProxyFactory(@Nonnull Map<String, String> credential, @Nonnull EventBus eventBus) {
        this.credential = credential;
        this.eventBus = eventBus;
    }

    protected void setKeyProvider(AuthKeyProvider keyProvider) {
        this.keyProvider = keyProvider;
    }

    public final HttpTransport getHttpTransport() throws GeneralSecurityException, IOException {
        if (this.httpTransport == null) {
            this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        return this.httpTransport;
    }

    public final JsonFactory getJsonFactory() {
        if (this.jsonFactory == null) {
            this.jsonFactory = JacksonFactory.getDefaultInstance();
        }
        return this.jsonFactory;
    }

    public String getProjectId(@Nullable String prefix) {
        return this.getStringValue(prefix, "projectId");
    }

    public String getClientId(@Nullable String prefix) {
        return this.getStringValue(prefix, "clientId");
    }

    public final boolean isDisableGZipContent(@Nullable String prefix) {
        return this.getBoolean("disableGZipContent", prefix);
    }

    public List<String> getScopes(@Nullable String prefix) {
        String values = this.getStringValue(prefix, "scopes");
        if (values == null) {
            return Collections.emptyList();
        }
        List list = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)values);
        return Collections.unmodifiableList(list);
    }

    public final String getServiceAccountEmail(@Nullable String prefix) {
        return this.getStringValue(prefix, "serviceAccountEmail");
    }

    public final String getApplicationName(@Nullable String prefix) {
        return this.getStringValue(prefix, "appName");
    }

    public final String getFileName(@Nullable String prefix) {
        return this.getStringValue(prefix, "fileName");
    }

    public final String getFileNameJson(@Nullable String prefix) {
        return this.getStringValue(prefix, "fileNameJson");
    }

    public final String getApiKey(@Nullable String prefix) {
        return this.getStringValue(prefix, "apiKey");
    }

    public final String getEndpointUrl(@Nullable String prefix) {
        return this.getStringValue(prefix, "endpointUrl");
    }

    public int getNumberOfRetries(@Nullable String prefix) {
        return this.getInteger("numberOfRetries", "1", prefix);
    }

    public int getReadTimeout(@Nullable String prefix) {
        return this.getInteger("readTimeout", "20000", prefix);
    }

    private int getInteger(@Nonnull String property, @Nonnull String defaultValue, @Nullable String prefix) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            prefix = "default";
        }
        String errorMessage = "Property name is expected";
        String value = this.credential.get("credential." + prefix + "." + (String)Preconditions.checkNotNull((Object)property, (Object)errorMessage));
        if (value == null) {
            value = this.credential.get("credential.default." + (String)Preconditions.checkNotNull((Object)property));
        }
        if (value == null) {
            value = (String)Preconditions.checkNotNull((Object)defaultValue, (Object)"Default value is expected");
        }
        return Integer.parseInt(value);
    }

    public final boolean isCredentialOn(@Nullable String prefix) {
        return this.getBoolean("on", prefix);
    }

    private boolean getBoolean(@Nonnull String property, @Nullable String prefix) {
        String fullProperty;
        String value;
        if (Strings.isNullOrEmpty((String)prefix)) {
            prefix = "default";
        }
        if ((value = this.credential.get(fullProperty = "credential." + prefix + "." + property)) == null) {
            fullProperty = "credential.default." + property;
            value = this.credential.get(fullProperty);
        }
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    private String getStringValue(String prefix, String property) {
        String value;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)property) ? 1 : 0) != 0);
        if (Strings.isNullOrEmpty((String)prefix)) {
            prefix = "default";
        }
        if ((value = this.credential.get("credential." + prefix + "." + property)) == null) {
            value = this.credential.get("credential.default." + property);
        }
        this.defaultPropertyValueCheck(prefix, property, value);
        return value;
    }

    private void defaultPropertyValueCheck(String prefix, String property, String value) {
        if (value != null || !"default".equals(prefix)) {
            return;
        }
        String fullProperty = "credential.default." + property;
        String className = ApiCredential.class.getName();
        String message = "No value configured for default credential: '" + fullProperty + "'";
        throw new MissingResourceException(message, className, fullProperty);
    }

    public HttpRequestInitializer authorize(@Nonnull Collection<String> scopes, @Nullable String userAccount, @Nonnull String prefix) throws GeneralSecurityException, IOException {
        GoogleCredential googleCredential;
        Collection checkedScopes = (Collection)Preconditions.checkNotNull(scopes, (Object)"Scopes is mandatory");
        if (this.isJsonConfiguration((String)Preconditions.checkNotNull((Object)prefix, (Object)"API short name is mandatory"))) {
            InputStream json = this.getServiceAccountJson(prefix);
            googleCredential = new ConfiguredByJsonGoogleCredential(json, prefix).setTransport(this.getHttpTransport()).setJsonFactory(this.getJsonFactory()).setServiceAccountScopes(checkedScopes).setServiceAccountUser(userAccount).build();
        } else {
            String serviceAccountEmail = this.getServiceAccountEmail(prefix);
            if (serviceAccountEmail == null) {
                throw new NullPointerException("Missing service account email.");
            }
            URL resource = this.getServiceAccountPrivateKeyP12Resource(prefix);
            googleCredential = new ConfiguredGoogleCredential(prefix).setTransport(this.getHttpTransport()).setJsonFactory(this.getJsonFactory()).setServiceAccountId(serviceAccountEmail).setServiceAccountScopes(checkedScopes).setServiceAccountPrivateKeyFromP12File(new File(resource.getPath())).setServiceAccountUser(userAccount).build();
        }
        return googleCredential;
    }

    public boolean isJsonConfiguration(String prefix) {
        if (this.keyProvider != null && this.keyProvider.isConfigured(prefix)) {
            return true;
        }
        try {
            return this.getFileNameJson(prefix) != null;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public URL getServiceAccountPrivateKeyP12Resource(String prefix) {
        String fileName = this.getFileName(prefix);
        return GoogleApiProxyFactory.class.getResource(fileName);
    }

    public InputStream getServiceAccountJson(String prefix) {
        InputStream stream;
        if (this.keyProvider != null && this.keyProvider.isConfigured(prefix)) {
            stream = this.keyProvider.get(prefix);
        } else {
            String fileName = this.getFileNameJson(prefix);
            stream = GoogleApiProxyFactory.class.getResourceAsStream(fileName);
            if (stream == null) {
                throw new IllegalArgumentException("No file has been found with name '" + fileName + "'");
            }
        }
        return stream;
    }

    public HttpRequestInitializer newRequestConfig(@Nullable String prefix, @Nullable HttpResponseInterceptor interceptor) {
        return new RequestConfig(prefix, interceptor);
    }

    private PrivateKey privateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem);
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IOException("Unexpected exception reading PKCS data", e);
        }
    }

    protected final void configureHttpRequest(@Nonnull HttpRequest request, int numberOfRetries, int readTimeout) {
        request.setNumberOfRetries(numberOfRetries);
        request.setReadTimeout(readTimeout);
    }

    private class ConfiguredByJsonGoogleCredential
    extends ConfiguredGoogleCredential {
        ConfiguredByJsonGoogleCredential(InputStream jsonStream, String prefix) throws IOException {
            String projectId;
            super(prefix);
            JsonObjectParser parser = new JsonObjectParser(GoogleApiProxyFactory.this.getJsonFactory());
            GenericJson fileContents = (GenericJson)parser.parseAndClose(jsonStream, Charsets.UTF_8, GenericJson.class);
            String clientId = (String)fileContents.get((Object)"client_id");
            String clientEmail = (String)fileContents.get((Object)"client_email");
            String privateKeyPem = (String)fileContents.get((Object)"private_key");
            String privateKeyId = (String)fileContents.get((Object)"private_key_id");
            if (clientId == null || clientEmail == null || privateKeyPem == null || privateKeyId == null) {
                throw new IOException("Error reading service account credential from stream, expecting  'client_id', 'client_email', 'private_key' and 'private_key_id'.");
            }
            PrivateKey privateKey = GoogleApiProxyFactory.this.privateKeyFromPkcs8(privateKeyPem);
            this.setServiceAccountId(clientEmail);
            this.setServiceAccountPrivateKey(privateKey);
            this.setServiceAccountPrivateKeyId(privateKeyId);
            String tokenUri = (String)fileContents.get((Object)"token_uri");
            if (tokenUri != null) {
                this.setTokenServerEncodedUrl(tokenUri);
            }
            if ((projectId = (String)fileContents.get((Object)"project_id")) != null) {
                this.setServiceAccountProjectId(projectId);
            }
        }
    }

    private class ConfiguredGoogleCredential
    extends GoogleCredential.Builder {
        private final int numberOfRetries;
        private final int readTimeout;

        private ConfiguredGoogleCredential(String prefix) {
            this.numberOfRetries = GoogleApiProxyFactory.this.getNumberOfRetries(prefix);
            this.readTimeout = GoogleApiProxyFactory.this.getReadTimeout(prefix);
        }

        public GoogleCredential build() {
            return new GoogleCredential(this){

                public void intercept(HttpRequest request) throws IOException {
                    String authorization = request.getHeaders().getAuthorization();
                    if (authorization == null) {
                        super.intercept(request);
                    }
                    GoogleApiProxyFactory.this.eventBus.post((Object)new BeforeRequestEvent(request));
                }

                public void initialize(HttpRequest request) throws IOException {
                    super.initialize(request);
                    GoogleApiProxyFactory.this.configureHttpRequest(request, ConfiguredGoogleCredential.this.numberOfRetries, ConfiguredGoogleCredential.this.readTimeout);
                }
            };
        }
    }

    private class RequestConfig
    implements HttpRequestInitializer {
        private final int numberOfRetries;
        private final int readTimeout;
        private final HttpResponseInterceptor responseInterceptor;
        HttpExecuteInterceptor interceptor = new HttpExecuteInterceptor(){

            public void intercept(HttpRequest request) {
                GoogleApiProxyFactory.this.eventBus.post((Object)new BeforeRequestEvent(request));
            }
        };

        private RequestConfig(String prefix, HttpResponseInterceptor responseInterceptor) {
            this.numberOfRetries = GoogleApiProxyFactory.this.getNumberOfRetries(prefix);
            this.readTimeout = GoogleApiProxyFactory.this.getReadTimeout(prefix);
            this.responseInterceptor = responseInterceptor;
        }

        public void initialize(HttpRequest request) {
            GoogleApiProxyFactory.this.configureHttpRequest(request, this.numberOfRetries, this.readTimeout);
            request.setInterceptor(this.interceptor);
            if (this.responseInterceptor != null) {
                request.setResponseInterceptor(this.responseInterceptor);
            }
        }
    }
}

