/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.HttpHeaders;
import com.google.common.base.Strings;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.AuthRequest;
import org.ctoolkit.restapi.client.RequestCredential;
import org.ctoolkit.restapi.client.provider.TokenProvider;

class GoogleRequestHeaders {
    private final HttpHeaders headers;
    private AuthRequest.AuthScheme authScheme;
    private TokenProvider<Object> provider;
    private Object onBehalfOf;

    GoogleRequestHeaders(Object remoteRequest) {
        this.headers = remoteRequest instanceof AbstractGoogleClientRequest ? ((AbstractGoogleClientRequest)remoteRequest).getRequestHeaders() : new HttpHeaders();
    }

    GoogleRequestHeaders() {
        this.headers = new HttpHeaders();
    }

    void acceptLanguage(@Nullable Locale locale) {
        if (locale != null) {
            String languageTag = new Locale(locale.getLanguage(), locale.getCountry()).toLanguageTag();
            this.headers.put("Accept-Language", (Object)languageTag);
        }
    }

    void contentType(@Nullable String type) {
        if (type != null) {
            this.headers.setContentType(type);
        }
    }

    void setAuthScheme(AuthRequest.AuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    void setOnBehalfOf(Object onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    void setAuthorizationIf(Function<Class<?>, TokenProvider<Object>> function) {
        if (this.provider == null && this.onBehalfOf != null) {
            this.provider = function.apply(this.onBehalfOf.getClass());
            if (this.provider == null) {
                String msg = "Missing binding between TokenProvider and on behalf of user: " + TokenProvider.class.getSimpleName() + "<" + this.onBehalfOf.getClass().getName() + ">";
                throw new IllegalArgumentException(msg);
            }
        }
        if (this.provider != null) {
            Map headers;
            String token = this.provider.token(this.authScheme, this.onBehalfOf);
            if (token != null) {
                this.headers.setAuthorization(token);
            }
            if ((headers = this.provider.headers(this.onBehalfOf)) != null) {
                this.headers.putAll(headers);
            }
        }
    }

    void setTokenCreator(@Nullable TokenProvider<?> provider) {
        this.provider = provider;
    }

    void addHeader(@Nonnull String header, @Nonnull String value) {
        this.headers.put(header, (Object)value);
    }

    void fillInCredential(@Nullable Map<String, Object> params) {
        RequestCredential credential = new RequestCredential();
        credential.fillInFrom(params, false);
        String apiKey = credential.getApiKey();
        if (!Strings.isNullOrEmpty((String)apiKey)) {
            this.provider = () -> apiKey;
        }
    }

    HttpHeaders getHeaders() {
        return this.headers;
    }
}

