/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.ctoolkit.restapi.client.SingleUploadMediaRequest;
import org.ctoolkit.restapi.client.UploadMediaProvider;
import org.ctoolkit.restapi.client.adapter.InputStreamMediaProvider;
import org.ctoolkit.restapi.client.adapter.InputStreamUploadRequest;
import org.ctoolkit.restapi.client.adapter.RestFacadeAdapter;

class InputStreamUploadMediaRequestProvider<T>
implements UploadMediaProvider<T> {
    private final RestFacadeAdapter adapter;
    private final T resource;

    InputStreamUploadMediaRequestProvider(@Nonnull RestFacadeAdapter adapter, @Nonnull T resource) {
        this.adapter = (RestFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.resource = Preconditions.checkNotNull(resource);
    }

    public SingleUploadMediaRequest<T> data(@Nonnull File file) {
        return this.data(new InputStreamMediaProvider(file));
    }

    public SingleUploadMediaRequest<T> data(@Nonnull InputStream inputStream) {
        return this.data(new InputStreamMediaProvider(inputStream));
    }

    public SingleUploadMediaRequest<T> data(@Nonnull byte[] array) {
        return this.data(new InputStreamMediaProvider(array));
    }

    public SingleUploadMediaRequest<T> data(@Nonnull byte[] array, int offset, int length) {
        return this.data(new InputStreamMediaProvider(array, offset, length));
    }

    private SingleUploadMediaRequest<T> data(InputStreamMediaProvider provider) {
        return new InputStreamUploadRequest<T>(this.adapter, this.resource, provider);
    }
}

