/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.ctoolkit.restapi.client.Identifier;
import org.ctoolkit.restapi.client.PayloadRequest;
import org.ctoolkit.restapi.client.SingleUploadMediaRequest;
import org.ctoolkit.restapi.client.adaptee.MediaProvider;
import org.ctoolkit.restapi.client.adapter.RestFacadeAdapter;

class InputStreamUploadRequest<T>
implements SingleUploadMediaRequest<T> {
    private final RestFacadeAdapter adapter;
    private final T resource;
    private final MediaProvider provider;
    private Identifier identifier;

    InputStreamUploadRequest(@Nonnull RestFacadeAdapter adapter, @Nonnull T resource, @Nonnull MediaProvider provider) {
        this.adapter = (RestFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.resource = Preconditions.checkNotNull(resource);
        this.provider = (MediaProvider)Preconditions.checkNotNull((Object)provider);
    }

    public PayloadRequest<T> insert() {
        return this.adapter.internalInsert(this.resource, this.identifier, this.provider);
    }

    public SingleUploadMediaRequest<T> ofType(@Nonnull String type) {
        this.provider.setType((String)Preconditions.checkNotNull((Object)type));
        return this;
    }

    public SingleUploadMediaRequest<T> closeStreamAtTheEnd(boolean closeStream) {
        this.provider.setCloseInputStream(closeStream);
        return this;
    }

    public SingleUploadMediaRequest<T> identifiedBy(@Nonnull Identifier identifier) {
        this.identifier = (Identifier)Preconditions.checkNotNull((Object)identifier);
        return this;
    }

    public SingleUploadMediaRequest<T> identifiedBy(@Nonnull String identifier) {
        Preconditions.checkNotNull((Object)identifier);
        return this.identifiedBy(new Identifier(new String[]{identifier}));
    }

    public SingleUploadMediaRequest<T> identifiedBy(@Nonnull Long identifier) {
        Preconditions.checkNotNull((Object)identifier);
        return this.identifiedBy(new Identifier(new Long[]{identifier}));
    }

    public PayloadRequest<T> update() {
        if (this.identifier == null) {
            throw new IllegalArgumentException("For update operation the identifier is being required!");
        }
        return this.adapter.internalUpdate(this.resource, this.identifier, this.provider);
    }
}

