/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.AuthRequest;
import org.ctoolkit.restapi.client.ListRetrievalRequest;
import org.ctoolkit.restapi.client.Request;
import org.ctoolkit.restapi.client.RequestCredential;
import org.ctoolkit.restapi.client.adaptee.ListExecutorAdaptee;
import org.ctoolkit.restapi.client.adapter.AuthRequestImpl;
import org.ctoolkit.restapi.client.adapter.GoogleRequestHeaders;
import org.ctoolkit.restapi.client.adapter.RestFacadeAdapter;
import org.ctoolkit.restapi.client.provider.TokenProvider;

class ListRequest<T>
implements ListRetrievalRequest<T> {
    private final Class<T> resource;
    private final RestFacadeAdapter adapter;
    private final ListExecutorAdaptee<?> adaptee;
    private final Object remoteRequest;
    private Map<String, Object> params;
    private Locale withLocale;
    private int start = -1;
    private int length = -1;
    private String orderBy;
    private Boolean ascending;
    private GoogleRequestHeaders filler;

    ListRequest(@Nonnull Class<T> resource, @Nonnull RestFacadeAdapter adapter, @Nonnull ListExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest) {
        this.resource = (Class)Preconditions.checkNotNull(resource);
        this.adapter = (RestFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.adaptee = (ListExecutorAdaptee)Preconditions.checkNotNull(adaptee);
        this.remoteRequest = Preconditions.checkNotNull((Object)remoteRequest);
        this.params = new HashMap<String, Object>();
        this.filler = new GoogleRequestHeaders(remoteRequest);
    }

    public <U> U underlying(Class<U> type) {
        return (U)this.remoteRequest;
    }

    public List<T> finish() {
        return this.finish((Map)null, this.withLocale);
    }

    public List<T> finish(@Nonnull RequestCredential credential) {
        Preconditions.checkNotNull((Object)credential);
        credential.populate(this.params);
        return this.finish();
    }

    public List<T> finish(int start, int length) {
        if (start < 0 || length < 0) {
            String msg = "start: '" + start + "' or length: '" + length + "' property cannot have negative values.";
            throw new IllegalArgumentException(msg);
        }
        this.start = start;
        this.length = length;
        return this.finish((Map)null, (Locale)null);
    }

    public List<T> finish(@Nullable Map<String, Object> criteria) {
        return this.finish((Map)criteria, this.withLocale);
    }

    public List<T> finish(@Nullable Locale locale) {
        return this.finish((Map)null, locale);
    }

    public List<T> finish(@Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        if (parameters != null) {
            this.params.putAll(parameters);
        }
        this.filler.acceptLanguage(locale);
        return this.adapter.callbackExecuteList(this.adaptee, this.remoteRequest, this.resource, this.filler, this.params, locale, this.start, this.length, this.orderBy, this.ascending);
    }

    public ListRetrievalRequest<T> configWith(@Nonnull Properties properties) {
        Preconditions.checkNotNull((Object)properties);
        RequestCredential.populate((Properties)properties, this.params);
        return this;
    }

    public ListRetrievalRequest<T> forLang(@Nonnull Locale locale) {
        this.withLocale = (Locale)Preconditions.checkNotNull((Object)locale);
        return this;
    }

    public Request<List<T>> add(@Nonnull String name, @Nonnull Object value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.params.put(name, value);
        return this;
    }

    public Request<List<T>> add(@Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.params.put(name, value);
        return this;
    }

    public Request<List<T>> addHeader(@Nonnull String header, @Nonnull String value) {
        Preconditions.checkNotNull((Object)header);
        Preconditions.checkNotNull((Object)value);
        this.filler.addHeader(header, value);
        return this;
    }

    public Request<List<T>> onBehalfOf(@Nonnull Object of) {
        this.filler.setOnBehalfOf(of);
        return this;
    }

    public AuthRequest<List<T>> authBy(@Nonnull String token) {
        Preconditions.checkNotNull((Object)token, (Object)"Authorization token expected to be not null");
        this.filler.setTokenCreator(() -> token);
        return new AuthRequestImpl<List<T>>(this, this.filler);
    }

    public AuthRequest<List<T>> authBy(@Nonnull TokenProvider<?> provider) {
        this.filler.setTokenCreator((TokenProvider)Preconditions.checkNotNull(provider, (Object)"Token provider can't be null"));
        return new AuthRequestImpl<List<T>>(this, this.filler);
    }

    public ListRetrievalRequest<T> start(int start) {
        if (start < 0) {
            String msg = "start: '" + start + "' property cannot have negative value.";
            throw new IllegalArgumentException(msg);
        }
        this.start = start;
        return this;
    }

    public ListRetrievalRequest<T> length(int length) {
        if (length < 0) {
            String msg = "length: '" + length + "' property cannot have negative value.";
            throw new IllegalArgumentException(msg);
        }
        this.length = length;
        return this;
    }

    public ListRetrievalRequest<T> orderBy(@Nullable String property) {
        this.orderBy = property;
        return this;
    }

    public ListRetrievalRequest<T> sortAscending(boolean ascending) {
        this.ascending = ascending;
        return this;
    }
}

