/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.DownloadRequest;
import org.ctoolkit.restapi.client.Identifier;
import org.ctoolkit.restapi.client.SingleDownloadMediaRequest;
import org.ctoolkit.restapi.client.adapter.RestFacadeAdapter;

class OutputStreamDownloadRequest
implements SingleDownloadMediaRequest {
    private final RestFacadeAdapter adapter;
    private final Class<?> resource;
    private final OutputStream output;
    private String type;

    OutputStreamDownloadRequest(@Nonnull RestFacadeAdapter adapter, @Nonnull Class<?> resource, @Nonnull OutputStream output) {
        this.adapter = (RestFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.resource = (Class)Preconditions.checkNotNull(resource);
        this.output = (OutputStream)Preconditions.checkNotNull((Object)output);
    }

    public DownloadRequest identifiedBy(@Nonnull Identifier identifier) {
        Preconditions.checkNotNull((Object)identifier);
        return this.adapter.prepareDownloadRequest(this.resource, identifier, this.output, this.type);
    }

    public DownloadRequest identifiedBy(@Nonnull String identifier) {
        Preconditions.checkNotNull((Object)identifier);
        return this.identifiedBy(new Identifier(new String[]{identifier}));
    }

    public DownloadRequest identifiedBy(@Nonnull Long identifier) {
        Preconditions.checkNotNull((Object)identifier);
        return this.identifiedBy(new Identifier(new Long[]{identifier}));
    }

    public SingleDownloadMediaRequest ofType(@Nullable String type) {
        this.type = type;
        return this;
    }
}

