/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLHandshakeException;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import org.ctoolkit.restapi.client.ClientErrorException;
import org.ctoolkit.restapi.client.DeleteIdentification;
import org.ctoolkit.restapi.client.DownloadMediaProvider;
import org.ctoolkit.restapi.client.DownloadRequest;
import org.ctoolkit.restapi.client.ForbiddenException;
import org.ctoolkit.restapi.client.HttpFailureException;
import org.ctoolkit.restapi.client.Identifier;
import org.ctoolkit.restapi.client.NotFoundException;
import org.ctoolkit.restapi.client.PayloadRequest;
import org.ctoolkit.restapi.client.RemoteServerErrorException;
import org.ctoolkit.restapi.client.RequestCredential;
import org.ctoolkit.restapi.client.RestFacade;
import org.ctoolkit.restapi.client.RetrievalRequest;
import org.ctoolkit.restapi.client.ServiceUnavailableException;
import org.ctoolkit.restapi.client.SingleRetrievalIdentification;
import org.ctoolkit.restapi.client.UnauthorizedException;
import org.ctoolkit.restapi.client.UpdateIdentification;
import org.ctoolkit.restapi.client.UploadMediaProvider;
import org.ctoolkit.restapi.client.adaptee.DeleteExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.DownloadExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.GetExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.InsertExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.ListExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.MediaProvider;
import org.ctoolkit.restapi.client.adaptee.NewExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.UnderlyingClientAdaptee;
import org.ctoolkit.restapi.client.adaptee.UpdateExecutorAdaptee;
import org.ctoolkit.restapi.client.adapter.ClientApi;
import org.ctoolkit.restapi.client.adapter.DeleteIdentificationImpl;
import org.ctoolkit.restapi.client.adapter.DeleteRequest;
import org.ctoolkit.restapi.client.adapter.DownloadRequestImpl;
import org.ctoolkit.restapi.client.adapter.DownloadResponseInterceptor;
import org.ctoolkit.restapi.client.adapter.GetRequest;
import org.ctoolkit.restapi.client.adapter.GoogleApiProxyFactory;
import org.ctoolkit.restapi.client.adapter.GoogleRequestHeaders;
import org.ctoolkit.restapi.client.adapter.InputStreamUploadMediaRequestProvider;
import org.ctoolkit.restapi.client.adapter.InsertRequest;
import org.ctoolkit.restapi.client.adapter.ListRequest;
import org.ctoolkit.restapi.client.adapter.NewInstanceRequest;
import org.ctoolkit.restapi.client.adapter.OutputStreamDownloadMediaRequestProvider;
import org.ctoolkit.restapi.client.adapter.SingleRetrievalIdentificationImpl;
import org.ctoolkit.restapi.client.adapter.Substitute;
import org.ctoolkit.restapi.client.adapter.UpdateIdentificationImpl;
import org.ctoolkit.restapi.client.adapter.UpdateRequest;
import org.ctoolkit.restapi.client.provider.LocalListResourceProvider;
import org.ctoolkit.restapi.client.provider.LocalResourceProvider;
import org.ctoolkit.restapi.client.provider.TokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestFacadeAdapter
implements RestFacade {
    private static final Logger logger = LoggerFactory.getLogger(RestFacadeAdapter.class);
    private final MapperFacade mapper;
    private final MapperFactory factory;
    private final Injector injector;
    private final GoogleApiProxyFactory apiFactory;
    private final Map<String, ClientApi> apis;
    private Substitute substitute;

    @javax.inject.Inject
    RestFacadeAdapter(MapperFacade mapper, MapperFactory factory, Injector injector, GoogleApiProxyFactory apiFactory, Map<String, ClientApi> apis) {
        this.mapper = mapper;
        this.factory = factory;
        this.injector = injector;
        this.apiFactory = apiFactory;
        this.apis = apis;
    }

    @Inject(optional=true)
    public void setSubstitute(Substitute substitute) {
        this.substitute = substitute;
    }

    MapperFacade getMapper() {
        return this.mapper;
    }

    Map<String, Object> executeDownload(@Nonnull MediaHttpDownloader downloader, @Nonnull DownloadExecutorAdaptee<?> adaptee, @Nonnull Class<?> resource, @Nonnull Identifier identifier, @Nonnull OutputStream output, @Nonnull DownloadResponseInterceptor interceptor, @Nonnull GoogleRequestHeaders grh, @Nullable Map<String, Object> params, @Nullable Locale locale) {
        RequestCredential credential = new RequestCredential();
        credential.fillInFrom(params, false);
        HttpHeaders headers = grh.getHeaders();
        String type = headers == null ? null : headers.getContentType();
        URL path = Objects.requireNonNull(adaptee).prepareDownloadUrl(identifier.root(), type, params, locale);
        if (path == null) {
            String msg = "URL to download a resource content cannot be null. Identifier: ";
            throw new IllegalArgumentException(msg + identifier + " Resource: " + resource.getName());
        }
        try {
            boolean remote;
            boolean bl = remote = this.substitute == null;
            if (!remote) {
                try {
                    this.substitute.download((Class)Preconditions.checkNotNull(resource), identifier, (OutputStream)Preconditions.checkNotNull((Object)output), headers, params, locale);
                }
                catch (Substitute.ProceedWithRemoteCall e) {
                    remote = true;
                }
            }
            if (remote) {
                grh.setAuthorizationIf(this::getTokenProvider);
                Objects.requireNonNull(downloader).download(new GenericUrl(path), headers, output);
            }
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, resource, identifier);
        }
        return interceptor.getHeaders();
    }

    DownloadRequest prepareDownloadRequest(@Nonnull Class<?> resource, @Nonnull Identifier identifier, @Nonnull OutputStream output, @Nullable String type) {
        MediaHttpDownloader downloader;
        DownloadResponseInterceptor interceptor = new DownloadResponseInterceptor();
        DownloadExecutorAdaptee adaptee = this.adaptee(DownloadExecutorAdaptee.class, (Class)Preconditions.checkNotNull(resource));
        String apiPrefix = adaptee.getApiPrefix();
        try {
            HttpRequestInitializer requestConfig = this.apiFactory.newRequestConfig(apiPrefix, interceptor);
            downloader = new MediaHttpDownloader(this.apiFactory.getHttpTransport(), requestConfig);
        }
        catch (GeneralSecurityException e) {
            logger.error("Application name: " + this.apiFactory.getApplicationName(apiPrefix) + " Endpoint URL: " + this.apiFactory.getEndpointUrl(apiPrefix), (Throwable)e);
            throw new UnauthorizedException(e.getMessage());
        }
        catch (IOException e) {
            logger.error("Application name: " + this.apiFactory.getApplicationName(apiPrefix) + " Endpoint URL: " + this.apiFactory.getEndpointUrl(apiPrefix), (Throwable)e);
            throw new RemoteServerErrorException(e.getMessage());
        }
        Identifier root = ((Identifier)Preconditions.checkNotNull((Object)identifier)).root();
        OutputStream os = (OutputStream)Preconditions.checkNotNull((Object)output);
        return new DownloadRequestImpl(this, adaptee, downloader, resource, root, os, interceptor, type);
    }

    public <T> PayloadRequest<T> newInstance(@Nonnull Class<T> resource) {
        Object remoteRequest;
        NewExecutorAdaptee adaptee = this.adaptee(NewExecutorAdaptee.class, (Class)Preconditions.checkNotNull(resource));
        try {
            remoteRequest = adaptee.prepareNew(resource.getSimpleName());
        }
        catch (IOException e) {
            throw new ClientErrorException(e.getMessage());
        }
        return new NewInstanceRequest<T>(resource, this, adaptee, remoteRequest);
    }

    public <T> UploadMediaProvider<T> upload(@Nonnull T resource) {
        return new InputStreamUploadMediaRequestProvider<Object>(this, Preconditions.checkNotNull(resource));
    }

    public <T> DownloadMediaProvider download(@Nonnull Class<T> resource) {
        return new OutputStreamDownloadMediaRequestProvider(this, (Class)Preconditions.checkNotNull(resource));
    }

    <R> R callbackNewInstance(@Nonnull NewExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nonnull GoogleRequestHeaders headers, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        Object remoteInstance = null;
        try {
            boolean remote;
            boolean bl = remote = this.substitute == null;
            if (!remote) {
                try {
                    remoteInstance = this.substitute.newInstance(Preconditions.checkNotNull((Object)remoteRequest), (Class)Preconditions.checkNotNull(responseType), parameters, locale);
                }
                catch (Substitute.ProceedWithRemoteCall e) {
                    remote = true;
                }
            }
            if (remote) {
                headers.setAuthorizationIf(this::getTokenProvider);
                remoteInstance = adaptee.executeNew(remoteRequest, parameters, locale);
            }
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, responseType, null);
        }
        Preconditions.checkNotNull(remoteInstance, (Object)"Callback must not return null");
        if (remoteInstance.getClass() == responseType) {
            return (R)remoteInstance;
        }
        return (R)this.mapper.map(remoteInstance, responseType);
    }

    public <T> SingleRetrievalIdentification<T> get(@Nonnull Class<T> resource) {
        return new SingleRetrievalIdentificationImpl<T>(this, resource);
    }

    <T> RetrievalRequest<T> internalGet(@Nonnull Class<T> resource, @Nonnull Identifier identifier) {
        Object remoteRequest;
        GetExecutorAdaptee adaptee = this.adaptee(GetExecutorAdaptee.class, (Class)Preconditions.checkNotNull(resource));
        try {
            String errorMessage = "Identifier for GET operation cannot be null.";
            remoteRequest = adaptee.prepareGet((Identifier)Preconditions.checkNotNull((Object)identifier, (Object)errorMessage));
        }
        catch (IOException e) {
            throw new ClientErrorException(e.getMessage());
        }
        return new GetRequest<T>(resource, identifier.root(), this, adaptee, remoteRequest);
    }

    <R> R callbackExecuteGet(@Nonnull GetExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nonnull Identifier identifier, @Nonnull GoogleRequestHeaders headers, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        LocalResourceProvider provider = this.getExistingResourceProvider((Class)Preconditions.checkNotNull(responseType));
        Object response = null;
        boolean requestForPersist = false;
        if (provider != null) {
            response = provider.get(identifier.root(), parameters, locale);
            boolean bl = requestForPersist = response == null;
        }
        if (response == null) {
            Object remoteObject = null;
            try {
                boolean remote;
                boolean bl = remote = this.substitute == null;
                if (!remote) {
                    try {
                        remoteObject = this.substitute.get(remoteRequest, responseType, identifier, parameters, locale);
                    }
                    catch (Substitute.ProceedWithRemoteCall e) {
                        remote = true;
                    }
                }
                if (remote) {
                    headers.setAuthorizationIf(this::getTokenProvider);
                    remoteObject = adaptee.executeGet(remoteRequest, parameters, locale);
                }
            }
            catch (IOException e) {
                throw this.prepareRetrievalException(e, responseType, identifier);
            }
            Preconditions.checkNotNull(remoteObject, (Object)"Callback must not return null");
            response = remoteObject.getClass() == responseType ? remoteObject : this.mapper.map(remoteObject, responseType);
        }
        if (requestForPersist && response != null) {
            provider.persist(response, identifier.root(), parameters, locale, null);
        }
        return (R)response;
    }

    public <T> ListRequest<T> list(@Nonnull Class<T> resource) {
        return this.list((Class)resource, (Identifier)null);
    }

    public <T> ListRequest<T> list(@Nonnull Class<T> resource, @Nullable Identifier parent) {
        Object remoteRequest;
        ListExecutorAdaptee adaptee = this.adaptee(ListExecutorAdaptee.class, (Class)Preconditions.checkNotNull(resource));
        try {
            remoteRequest = adaptee.prepareList(parent == null ? null : parent.root());
        }
        catch (IOException e) {
            throw new ClientErrorException(e.getMessage());
        }
        return new ListRequest<T>(resource, this, adaptee, remoteRequest);
    }

    <R> List<R> callbackExecuteList(@Nonnull ListExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nonnull GoogleRequestHeaders headers, @Nullable Map<String, Object> criteria, @Nullable Locale locale, int start, int length, @Nullable String orderBy, @Nullable Boolean ascending) {
        if (criteria == null) {
            criteria = new HashMap<String, Object>();
        }
        LocalListResourceProvider provider = this.getExistingListResourceProvider((Class)Preconditions.checkNotNull(responseType));
        List response = null;
        boolean requestForPersist = false;
        if (provider != null) {
            response = provider.list(criteria, locale, null);
            boolean bl = requestForPersist = response == null;
        }
        if (response == null) {
            List remoteList = null;
            try {
                boolean remote;
                boolean bl = remote = this.substitute == null;
                if (!remote) {
                    try {
                        remoteList = this.substitute.list(remoteRequest, responseType, criteria, locale, start, length, orderBy, ascending);
                    }
                    catch (Substitute.ProceedWithRemoteCall e) {
                        remote = true;
                    }
                }
                if (remote) {
                    headers.setAuthorizationIf(this::getTokenProvider);
                    remoteList = adaptee.executeList(remoteRequest, criteria, locale, Integer.valueOf(start), Integer.valueOf(length), orderBy, ascending);
                }
            }
            catch (IOException e) {
                throw this.prepareRetrievalException(e, responseType, null);
            }
            response = remoteList == null || remoteList.isEmpty() ? Lists.newArrayList() : (remoteList.get(0).getClass() == responseType ? remoteList : this.mapper.mapAsList((Iterable)remoteList, responseType));
        }
        if (requestForPersist && response != null && !response.isEmpty()) {
            provider.persistList(response, criteria, locale, null);
        }
        return response;
    }

    public <T> PayloadRequest<T> insert(@Nonnull T resource) {
        return this.insert(resource, null);
    }

    public <T> PayloadRequest<T> insert(@Nonnull T resource, @Nullable Identifier parentKey) {
        return this.internalInsert(resource, parentKey, null);
    }

    <T> PayloadRequest<T> internalInsert(@Nonnull T resource, @Nullable Identifier parentKey, @Nullable MediaProvider provider) {
        Object remoteRequest;
        Class<?> remoteResource = this.evaluateRemoteResource(Preconditions.checkNotNull(resource).getClass());
        Object source = resource.getClass() == remoteResource ? resource : this.mapper.map(resource, remoteResource);
        InsertExecutorAdaptee adaptee = this.adaptee(InsertExecutorAdaptee.class, resource.getClass());
        try {
            remoteRequest = adaptee.prepareInsert(source, parentKey == null ? null : parentKey.root(), provider);
        }
        catch (IOException e) {
            throw new ClientErrorException(e.getMessage());
        }
        Class<?> resourceClass = resource.getClass();
        return new InsertRequest(resourceClass, parentKey, this, adaptee, remoteRequest);
    }

    <R> R callbackExecuteInsert(@Nonnull InsertExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nullable Identifier parentKey, @Nonnull GoogleRequestHeaders headers, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        Object source = null;
        try {
            boolean remote;
            boolean bl = remote = this.substitute == null;
            if (!remote) {
                try {
                    source = this.substitute.insert(Preconditions.checkNotNull((Object)remoteRequest), (Class)Preconditions.checkNotNull(responseType), parentKey, parameters, locale);
                }
                catch (Substitute.ProceedWithRemoteCall e) {
                    remote = true;
                }
            }
            if (remote) {
                headers.setAuthorizationIf(this::getTokenProvider);
                source = adaptee.executeInsert(remoteRequest, parameters, locale);
            }
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, responseType, parentKey);
        }
        if (source == null) {
            return null;
        }
        if (source.getClass() == responseType) {
            return (R)source;
        }
        return (R)this.mapper.map(source, responseType);
    }

    public <T> UpdateIdentification<T> update(@Nonnull T resource) {
        return new UpdateIdentificationImpl<T>(this, resource);
    }

    <T> PayloadRequest<T> internalUpdate(@Nonnull T resource, @Nonnull Identifier identifier, @Nullable MediaProvider provider) {
        Object remoteRequest;
        Class<?> remoteResource = this.evaluateRemoteResource(resource.getClass());
        Object source = resource.getClass() == remoteResource ? resource : this.mapper.map(resource, remoteResource);
        UpdateExecutorAdaptee adaptee = this.adaptee(UpdateExecutorAdaptee.class, resource.getClass());
        try {
            String errorMessage = "Identifier for UPDATE operation cannot be null.";
            remoteRequest = adaptee.prepareUpdate(source, ((Identifier)Preconditions.checkNotNull((Object)identifier, (Object)errorMessage)).root(), provider);
        }
        catch (IOException e) {
            throw new ClientErrorException(e.getMessage());
        }
        Class<?> resourceClass = resource.getClass();
        return new UpdateRequest(resourceClass, identifier, this, adaptee, remoteRequest);
    }

    <R> R callbackExecuteUpdate(@Nonnull UpdateExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest, @Nonnull Class<R> responseType, @Nonnull Object identifier, @Nonnull GoogleRequestHeaders headers, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        Object source = null;
        try {
            boolean remote;
            boolean bl = remote = this.substitute == null;
            if (!remote) {
                try {
                    source = this.substitute.update(Preconditions.checkNotNull((Object)remoteRequest), (Class)Preconditions.checkNotNull(responseType), Preconditions.checkNotNull((Object)identifier), parameters, locale);
                }
                catch (Substitute.ProceedWithRemoteCall e) {
                    remote = true;
                }
            }
            if (remote) {
                headers.setAuthorizationIf(this::getTokenProvider);
                source = adaptee.executeUpdate(remoteRequest, parameters, locale);
            }
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, responseType, identifier);
        }
        if (source == null) {
            return null;
        }
        if (source.getClass() == responseType) {
            return (R)source;
        }
        return (R)this.mapper.map(source, responseType);
    }

    public <T> DeleteIdentification<T> delete(@Nonnull Class<T> resource) {
        return new DeleteIdentificationImpl<T>(this, resource);
    }

    public <C> C client(@Nonnull Class<C> type) {
        UnderlyingClientAdaptee adaptee = this.adaptee(UnderlyingClientAdaptee.class, type);
        return (C)adaptee.getUnderlyingClient();
    }

    public void impersonate(@Nonnull String userEmail, @Nonnull String api) {
        ClientApi provider = this.apis.get(api);
        if (provider == null) {
            throw new IllegalArgumentException(this.impersonateClientApiMissingErrorMessage(api));
        }
        String emailError = "User email cannot be null";
        provider.init(null, (String)Preconditions.checkNotNull((Object)userEmail, (Object)emailError));
    }

    public void impersonate(@Nonnull Collection<String> scopes, @Nonnull String userEmail, @Nonnull String api) {
        ClientApi provider = this.apis.get(api);
        if (provider == null) {
            throw new IllegalArgumentException(this.impersonateClientApiMissingErrorMessage(api));
        }
        String scopesError = "Scopes cannot be null";
        String emailError = "User email cannot be null";
        provider.init((Collection)Preconditions.checkNotNull(scopes, (Object)scopesError), (String)Preconditions.checkNotNull((Object)userEmail, (Object)emailError));
    }

    private String impersonateClientApiMissingErrorMessage(String api) {
        return "No API client found for '" + api + "'. Make sure API is installed in module, for example: install( new GoogleApiDriveModule() );";
    }

    <T> PayloadRequest<T> internalDelete(@Nonnull Class<T> resource, @Nonnull Identifier identifier) {
        Object remoteRequest;
        DeleteExecutorAdaptee adaptee = this.adaptee(DeleteExecutorAdaptee.class, (Class)Preconditions.checkNotNull(resource));
        try {
            String errorMessage = "Identifier for DELETE operation cannot be null.";
            remoteRequest = adaptee.prepareDelete(((Identifier)Preconditions.checkNotNull((Object)identifier, (Object)errorMessage)).root());
        }
        catch (IOException e) {
            throw new ClientErrorException(e.getMessage());
        }
        return new DeleteRequest(identifier, this, adaptee, remoteRequest);
    }

    <R> R callbackExecuteDelete(@Nonnull DeleteExecutorAdaptee<?> adaptee, @Nonnull Object remoteRequest, @Nonnull Object identifier, @Nonnull GoogleRequestHeaders headers, @Nullable Class<R> responseType, @Nullable Map<String, Object> parameters, @Nullable Locale locale) {
        Object response = null;
        try {
            boolean remote;
            boolean bl = remote = this.substitute == null;
            if (!remote) {
                try {
                    response = this.substitute.delete(Preconditions.checkNotNull((Object)remoteRequest), Preconditions.checkNotNull((Object)identifier), responseType, parameters, locale);
                }
                catch (Substitute.ProceedWithRemoteCall e) {
                    remote = true;
                }
            }
            if (remote) {
                headers.setAuthorizationIf(this::getTokenProvider);
                response = adaptee.executeDelete(remoteRequest, parameters, locale);
            }
        }
        catch (IOException e) {
            throw this.prepareUpdateException(e, responseType, identifier);
        }
        if (responseType == null || response == null) {
            return null;
        }
        if (response.getClass() == responseType) {
            return (R)response;
        }
        return (R)this.mapper.map(response, responseType);
    }

    private RuntimeException prepareRetrievalException(IOException e, Class<?> resource, @Nullable Object identifier) {
        return this.prepareException(e, resource, identifier, false);
    }

    private RuntimeException prepareUpdateException(IOException e, Class<?> resource, @Nullable Object identifier) {
        return this.prepareException(e, resource, identifier, true);
    }

    private RuntimeException prepareException(IOException e, @Nullable Class<?> resource, @Nullable Object identifier, boolean update) {
        String statusMessage;
        int statusCode = -1;
        if (e instanceof HttpResponseException) {
            statusCode = ((HttpResponseException)e).getStatusCode();
            statusMessage = ((HttpResponseException)e).getStatusMessage();
        } else if (e instanceof SocketTimeoutException) {
            statusCode = 408;
            statusMessage = e.getMessage();
        } else if (e instanceof UnknownHostException) {
            statusCode = 503;
            statusMessage = "Unknown host: " + e.getMessage();
        } else if (e instanceof SSLHandshakeException) {
            statusCode = 401;
            statusMessage = e.getMessage();
        } else {
            statusMessage = e.getMessage();
        }
        logger.warn("Response resource " + (resource == null ? " none" : resource.getName()) + ", identifier: " + identifier, (Throwable)e);
        Object toBeThrown = 400 == statusCode ? new ClientErrorException(statusMessage) : (401 == statusCode ? new UnauthorizedException(statusMessage) : (403 == statusCode ? new ForbiddenException(statusMessage) : (404 == statusCode && update ? new NotFoundException(statusMessage) : (404 == statusCode ? new NotFoundException(statusMessage) : (408 == statusCode ? new ServiceUnavailableException(statusMessage) : (400 < statusCode && statusCode < 499 ? new HttpFailureException(statusCode, statusMessage) : (500 == statusCode ? new RemoteServerErrorException(statusMessage) : (503 == statusCode ? new ServiceUnavailableException(statusMessage) : (statusCode > -1 ? new HttpFailureException(statusCode, statusMessage) : new RuntimeException(statusMessage))))))))));
        return toBeThrown;
    }

    private Class<?> evaluateRemoteResource(Class<?> resource) {
        Set types = this.factory.lookupMappedClasses(TypeFactory.valueOf(resource));
        Iterator iterator = types.iterator();
        Class remoteResource = iterator.hasNext() ? ((Type)iterator.next()).getRawType() : resource;
        return remoteResource;
    }

    private <A> A adaptee(Class<A> adapteeType, Class<?> resource) {
        Class<?> remoteResource = this.evaluateRemoteResource(resource);
        A adaptee = this.getExecutorAdaptee(adapteeType, remoteResource);
        if (adaptee == null && remoteResource == resource) {
            String msg = "Missing binding between adaptee and resource: " + adapteeType.getSimpleName() + "<" + resource.getName() + ">";
            throw new NotFoundException(msg);
        }
        if (adaptee == null) {
            String msg = "Missing binding between adaptee and remote resource: " + adapteeType.getSimpleName() + "<" + remoteResource.getName() + ">. The remote resource " + remoteResource.getName() + " is being mapped to " + resource.getName() + ".";
            throw new NotFoundException(msg);
        }
        return adaptee;
    }

    <T> LocalResourceProvider<T> getExistingResourceProvider(@Nonnull Class<T> resource) {
        LocalResourceProvider provider = null;
        ParameterizedType pt = Types.newParameterizedType(LocalResourceProvider.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{resource});
        Binding binding = this.injector.getExistingBinding(Key.get((TypeLiteral)TypeLiteral.get((java.lang.reflect.Type)pt)));
        if (binding != null) {
            provider = (LocalResourceProvider)binding.getProvider().get();
        }
        return provider;
    }

    <T> LocalListResourceProvider<T> getExistingListResourceProvider(@Nonnull Class<T> resource) {
        LocalListResourceProvider provider = null;
        ParameterizedType pt = Types.newParameterizedType(LocalListResourceProvider.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{resource});
        Binding binding = this.injector.getExistingBinding(Key.get((TypeLiteral)TypeLiteral.get((java.lang.reflect.Type)pt)));
        if (binding != null) {
            provider = (LocalListResourceProvider)binding.getProvider().get();
        }
        return provider;
    }

    <A> A getExecutorAdaptee(@Nonnull Class<A> adapteeType, @Nonnull Class<?> resource) {
        Object adaptee = null;
        ParameterizedType pt = Types.newParameterizedType(adapteeType, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{resource});
        Binding binding = this.injector.getExistingBinding(Key.get((TypeLiteral)TypeLiteral.get((java.lang.reflect.Type)pt)));
        if (binding != null) {
            adaptee = binding.getProvider().get();
        }
        return (A)adaptee;
    }

    TokenProvider<Object> getTokenProvider(@Nonnull Class<?> type) {
        ParameterizedType pt = Types.newParameterizedType(TokenProvider.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{type});
        Binding binding = this.injector.getExistingBinding(Key.get((TypeLiteral)TypeLiteral.get((java.lang.reflect.Type)pt)));
        TokenProvider provider = binding != null ? (TokenProvider)binding.getProvider().get() : null;
        return provider;
    }
}

