/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.ctoolkit.restapi.client.Identifier;
import org.ctoolkit.restapi.client.RetrievalRequest;
import org.ctoolkit.restapi.client.SingleRetrievalIdentification;
import org.ctoolkit.restapi.client.adapter.RestFacadeAdapter;

class SingleRetrievalIdentificationImpl<T>
implements SingleRetrievalIdentification<T> {
    private final RestFacadeAdapter adapter;
    private final Class<T> resource;

    SingleRetrievalIdentificationImpl(@Nonnull RestFacadeAdapter adapter, @Nonnull Class<T> resource) {
        this.adapter = (RestFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.resource = (Class)Preconditions.checkNotNull(resource);
    }

    public RetrievalRequest<T> identifiedBy(@Nonnull Identifier identifier) {
        return this.adapter.internalGet(this.resource, identifier);
    }

    public RetrievalRequest<T> identifiedBy(@Nonnull String identifier) {
        return this.adapter.internalGet(this.resource, new Identifier(new String[]{identifier}));
    }

    public RetrievalRequest<T> identifiedBy(@Nonnull Long identifier) {
        return this.adapter.internalGet(this.resource, new Identifier(new Long[]{identifier}));
    }
}

