/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.appengine;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.ctoolkit.restapi.client.RestFacade;
import org.ctoolkit.restapi.client.adapter.ResourceProviderInjector;
import org.ctoolkit.restapi.client.adapter.RestFacadeAdapter;
import org.ctoolkit.restapi.client.appengine.GoogleApiProxyFactoryAppEngine;
import org.ctoolkit.restapi.client.appengine.ResourceProviderGuiceInjector;
import org.ctoolkit.restapi.client.googleapis.Credential;
import org.ctoolkit.restapi.client.googleapis.GoogleApiProxyFactory;

public class CtoolkitRestFacadeAppEngineModule
extends AbstractModule {
    protected void configure() {
        this.bind(RestFacade.class).to(RestFacadeAdapter.class).in(Singleton.class);
        this.bind(ResourceProviderInjector.class).to(ResourceProviderGuiceInjector.class);
        this.bind(EventBus.class).in(Singleton.class);
        this.bind(GoogleApiProxyFactory.class).to(GoogleApiProxyFactoryAppEngine.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    @Credential
    Map<String, String> provideCredentialProperties(Injector injector) {
        return new CredentialMap(injector);
    }

    private static class CredentialMap
    implements Map<String, String> {
        private final Injector injector;

        CredentialMap(Injector injector) {
            this.injector = injector;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object property) {
            Preconditions.checkNotNull((Object)property);
            if (Strings.isNullOrEmpty((String)property.toString())) {
                return false;
            }
            Key key = Key.get(String.class, (Annotation)Names.named((String)property.toString()));
            Binding binding = this.injector.getExistingBinding(key);
            return binding != null;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String get(Object property) {
            Preconditions.checkNotNull((Object)property);
            if (Strings.isNullOrEmpty((String)property.toString())) {
                return null;
            }
            Key key = Key.get(String.class, (Annotation)Names.named((String)property.toString()));
            Binding binding = this.injector.getExistingBinding(key);
            return binding == null ? null : (String)binding.getProvider().get();
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<String> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

