/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.appengine;

import com.google.api.client.googleapis.extensions.appengine.auth.oauth2.AppIdentityCredential;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Map;
import org.ctoolkit.restapi.client.ApiToken;
import org.ctoolkit.restapi.client.adapter.BeforeRequestEvent;
import org.ctoolkit.restapi.client.appengine.AppIdentityCredentialApiToken;
import org.ctoolkit.restapi.client.googleapis.Credential;
import org.ctoolkit.restapi.client.googleapis.GoogleApiProxyFactory;
import org.ctoolkit.restapi.client.provider.AuthKeyProvider;

class GoogleApiProxyFactoryAppEngine
extends GoogleApiProxyFactory {
    @javax.inject.Inject
    protected GoogleApiProxyFactoryAppEngine(@Credential Map<String, String> properties, EventBus eventBus, FacadeApiInit facadeInit) {
        super(properties, eventBus, facadeInit.keyProvider);
    }

    public ApiToken<? extends HttpRequestInitializer> authorize(Collection<String> scopes, String userAccount, String prefix) throws GeneralSecurityException, IOException {
        if (super.isCredentialOn(prefix)) {
            return super.authorize(scopes, userAccount, prefix);
        }
        return new AppIdentityCredentialApiToken(new ConfiguredAppIdentityCredential(scopes, prefix));
    }

    private class ConfiguredAppIdentityCredential
    extends AppIdentityCredential {
        private final int numberOfRetries;
        private final int readTimeout;

        ConfiguredAppIdentityCredential(Collection<String> scopes, String prefix) {
            super(scopes);
            this.numberOfRetries = GoogleApiProxyFactoryAppEngine.this.getNumberOfRetries(prefix);
            this.readTimeout = GoogleApiProxyFactoryAppEngine.this.getReadTimeout(prefix);
        }

        public void intercept(HttpRequest request) throws IOException {
            String authorization = request.getHeaders().getAuthorization();
            if (authorization == null) {
                super.intercept(request);
            }
            GoogleApiProxyFactoryAppEngine.this.eventBus.post((Object)new BeforeRequestEvent(request));
        }

        public void initialize(HttpRequest request) throws IOException {
            super.initialize(request);
            GoogleApiProxyFactoryAppEngine.this.configureHttpRequest(request, this.numberOfRetries, this.readTimeout);
        }
    }

    static class FacadeApiInit {
        @Inject(optional=true)
        AuthKeyProvider keyProvider = null;

        FacadeApiInit() {
        }
    }
}

