/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.appengine;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.ctoolkit.restapi.client.adapter.ResourceProviderInjector;
import org.ctoolkit.restapi.client.provider.LocalListResourceProvider;
import org.ctoolkit.restapi.client.provider.LocalResourceProvider;

class ResourceProviderGuiceInjector
implements ResourceProviderInjector {
    private final Injector injector;

    @Inject
    public ResourceProviderGuiceInjector(Injector injector) {
        this.injector = injector;
    }

    public <T> LocalResourceProvider<T> getExistingResourceProvider(@Nonnull Class<T> resource) {
        LocalResourceProvider provider = null;
        ParameterizedType pt = Types.newParameterizedType(LocalResourceProvider.class, (Type[])new Type[]{resource});
        Binding binding = this.injector.getExistingBinding(Key.get((TypeLiteral)TypeLiteral.get((Type)pt)));
        if (binding != null) {
            provider = (LocalResourceProvider)binding.getProvider().get();
        }
        return provider;
    }

    public <T> LocalListResourceProvider<T> getExistingListResourceProvider(@Nonnull Class<T> resource) {
        LocalListResourceProvider provider = null;
        ParameterizedType pt = Types.newParameterizedType(LocalListResourceProvider.class, (Type[])new Type[]{resource});
        Binding binding = this.injector.getExistingBinding(Key.get((TypeLiteral)TypeLiteral.get((Type)pt)));
        if (binding != null) {
            provider = (LocalListResourceProvider)binding.getProvider().get();
        }
        return provider;
    }

    public <A> A getExecutorAdaptee(@Nonnull Class<A> adapteeType, @Nonnull Class<?> resource) {
        Object provider = null;
        ParameterizedType pt = Types.newParameterizedType(adapteeType, (Type[])new Type[]{resource});
        Binding binding = this.injector.getExistingBinding(Key.get((TypeLiteral)TypeLiteral.get((Type)pt)));
        if (binding != null) {
            provider = binding.getProvider().get();
        }
        return (A)provider;
    }
}

