/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpHeaders;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.adaptee.MediaProvider;

public class AbstractGoogleClientAdaptee<C, M> {
    private final C client;

    public AbstractGoogleClientAdaptee(C client) {
        this.client = client;
    }

    protected final C client() {
        return this.client;
    }

    protected final AbstractGoogleJsonClientRequest get(Object request) {
        return (AbstractGoogleJsonClientRequest)request;
    }

    protected final M execute(Object request) throws IOException {
        return (M)this.get(request).execute();
    }

    protected final void acceptLanguage(@Nonnull AbstractGoogleJsonClientRequest request, @Nullable Locale locale) {
        Preconditions.checkNotNull((Object)request);
        this.acceptLanguage(request.getRequestHeaders(), locale);
    }

    protected final void acceptLanguage(@Nonnull HttpHeaders headers, @Nullable Locale locale) {
        Preconditions.checkNotNull((Object)headers);
        if (locale != null) {
            String languageTag = new Locale(locale.getLanguage(), locale.getCountry()).toLanguageTag();
            headers.put("Accept-Language", (Object)languageTag);
        }
    }

    protected final void fillCriteria(@Nonnull AbstractGoogleJsonClientRequest request, @Nullable Map<String, Object> criteria) {
        Preconditions.checkNotNull((Object)request);
        if (criteria != null) {
            for (Map.Entry<String, Object> entrySet : criteria.entrySet()) {
                Object value = entrySet.getValue();
                if (value instanceof Enum) {
                    value = ((Enum)value).name();
                }
                request.set(entrySet.getKey(), value);
            }
        }
    }

    protected final void fill(@Nonnull AbstractGoogleJsonClientRequest request, @Nullable Map<String, Object> criteria, @Nullable Locale locale) {
        Preconditions.checkNotNull((Object)request);
        this.fillCriteria(request, criteria);
        this.acceptLanguage(request, locale);
    }

    protected final AbstractInputStreamContent media(@Nullable MediaProvider<?> provider) {
        if (provider == null) {
            return null;
        }
        return (AbstractInputStreamContent)provider.media();
    }
}

