/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.ctoolkit.restapi.client.MediaRequest;
import org.ctoolkit.restapi.client.UploadMediaRequest;
import org.ctoolkit.restapi.client.adapter.InputStreamMediaProvider;
import org.ctoolkit.restapi.client.adapter.InputStreamUploadMediaRequest;
import org.ctoolkit.restapi.client.adapter.ResourceFacadeAdapter;

public class InputStreamMediaRequest<T>
implements MediaRequest<T> {
    private final ResourceFacadeAdapter adapter;
    private final T resource;

    InputStreamMediaRequest(@Nonnull ResourceFacadeAdapter adapter, @Nonnull T resource) {
        this.adapter = (ResourceFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.resource = Preconditions.checkNotNull(resource);
    }

    public UploadMediaRequest<T> upload(File file, String type) {
        return this.upload(new InputStreamMediaProvider(file, type));
    }

    public UploadMediaRequest<T> upload(InputStream inputStream, String type) {
        return this.upload(new InputStreamMediaProvider(inputStream, type));
    }

    public UploadMediaRequest<T> upload(byte[] media, String type) {
        return this.upload(new InputStreamMediaProvider(media, type));
    }

    public UploadMediaRequest<T> upload(byte[] array, int offset, int length, String type) {
        return this.upload(new InputStreamMediaProvider(array, offset, length, type));
    }

    private UploadMediaRequest<T> upload(InputStreamMediaProvider provider) {
        return new InputStreamUploadMediaRequest<T>(this.adapter, this.resource, provider);
    }
}

