/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ctoolkit.restapi.client.ClientErrorException;
import org.ctoolkit.restapi.client.SingleRequest;
import org.ctoolkit.restapi.client.adaptee.NewExecutorAdaptee;
import org.ctoolkit.restapi.client.adapter.ResourceFacadeAdapter;

public class NewInstanceRequest<T>
implements SingleRequest<T> {
    private final Class<T> resource;
    private final ResourceFacadeAdapter adapter;
    private final NewExecutorAdaptee adaptee;
    private final Object remoteRequest;

    NewInstanceRequest(@Nonnull Class<T> resource, @Nonnull ResourceFacadeAdapter adapter, @Nonnull NewExecutorAdaptee adaptee, @Nullable Object remoteRequest) {
        this.resource = (Class)Preconditions.checkNotNull(resource);
        this.adapter = (ResourceFacadeAdapter)Preconditions.checkNotNull((Object)adapter);
        this.adaptee = (NewExecutorAdaptee)Preconditions.checkNotNull((Object)adaptee);
        this.remoteRequest = remoteRequest;
    }

    public <Q> Q query(Class<Q> type) {
        return (Q)this.remoteRequest;
    }

    public T execute() {
        return this.execute(null, null);
    }

    public T execute(Map<String, Object> criteria) {
        return this.execute(criteria, null);
    }

    public T execute(Locale locale) {
        return this.execute(null, locale);
    }

    public T execute(Map<String, Object> parameters, Locale locale) {
        if (this.remoteRequest == null) {
            try {
                return this.resource.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ClientErrorException(400, e.getMessage());
            }
        }
        return this.adapter.callbackNewInstance(this.adaptee, this.remoteRequest, this.resource, parameters, locale);
    }
}

