/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.googleapis;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.ctoolkit.restapi.client.adapter.BeforeRequestEvent;

public abstract class GoogleApiCredentialFactory {
    protected final String projectId;
    protected final String clientId;
    protected final String serviceAccountEmail;
    protected final String applicationName;
    protected final String fileName;
    protected final String apiKey;
    protected final String endpointUrl;
    protected final boolean isDevelopmentEnvironment;
    protected final EventBus eventBus;
    protected int numberOfRetries = 1;
    private HttpTransport httpTransport;
    private JsonFactory jsonFactory;

    protected GoogleApiCredentialFactory(@Nonnull Builder builder, @Nonnull EventBus eventBus) {
        this.eventBus = eventBus;
        this.projectId = builder.projectId;
        this.clientId = builder.clientId;
        this.serviceAccountEmail = builder.serviceAccountEmail;
        this.applicationName = builder.applicationName;
        this.fileName = builder.fileName;
        this.apiKey = builder.apiKey;
        this.endpointUrl = builder.endpointUrl;
        this.isDevelopmentEnvironment = builder.developmentEnvironment;
        this.numberOfRetries = builder.numberOfRetries;
    }

    public final HttpTransport getHttpTransport() throws GeneralSecurityException, IOException {
        if (this.httpTransport == null) {
            this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        return this.httpTransport;
    }

    public final JsonFactory getJsonFactory() {
        if (this.jsonFactory == null) {
            this.jsonFactory = JacksonFactory.getDefaultInstance();
        }
        return this.jsonFactory;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public final String getServiceAccountEmail() {
        return this.serviceAccountEmail;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getApiKey() {
        return this.apiKey;
    }

    public final String getEndpointUrl() {
        return this.endpointUrl;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public final boolean isDevelopmentEnvironment() {
        return this.isDevelopmentEnvironment;
    }

    public HttpRequestInitializer authorize(Collection<String> scopes, String userAccount) throws GeneralSecurityException, IOException {
        if (this.serviceAccountEmail == null) {
            throw new NullPointerException();
        }
        URL resource = this.getServiceAccountPrivateKeyP12Resource();
        return new ConfiguredGoogleCredential().setTransport(this.getHttpTransport()).setJsonFactory(this.getJsonFactory()).setServiceAccountId(this.serviceAccountEmail).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(new File(resource.getPath())).setServiceAccountUser(userAccount).build();
    }

    public URL getServiceAccountPrivateKeyP12Resource() {
        if (this.fileName == null) {
            throw new NullPointerException();
        }
        return GoogleApiCredentialFactory.class.getResource(this.fileName);
    }

    public InputStream getServiceAccountPrivateKeyP12Stream() {
        if (this.fileName == null) {
            throw new NullPointerException();
        }
        return GoogleApiCredentialFactory.class.getResourceAsStream(this.fileName);
    }

    private class ConfiguredGoogleCredential
    extends GoogleCredential.Builder {
        private ConfiguredGoogleCredential() {
        }

        public GoogleCredential build() {
            return new GoogleCredential(this){

                public void intercept(HttpRequest request) throws IOException {
                    super.intercept(request);
                    GoogleApiCredentialFactory.this.eventBus.post((Object)new BeforeRequestEvent(request));
                }

                public void initialize(HttpRequest request) throws IOException {
                    super.initialize(request);
                    request.setNumberOfRetries(GoogleApiCredentialFactory.this.numberOfRetries);
                }
            };
        }
    }

    public static class Builder {
        private String projectId;
        private String clientId;
        private String serviceAccountEmail;
        private String applicationName;
        private String fileName;
        private String apiKey;
        private String endpointUrl;
        private boolean developmentEnvironment;
        private int numberOfRetries = 1;

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public Builder setServiceAccountEmail(String serviceAccountEmail) {
            this.serviceAccountEmail = serviceAccountEmail;
            return this;
        }

        public Builder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public Builder setDevelopmentEnvironment(boolean developmentEnvironment) {
            this.developmentEnvironment = developmentEnvironment;
            return this;
        }

        public void setNumberOfRetries(int numberOfRetries) {
            this.numberOfRetries = numberOfRetries;
        }
    }
}

