/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.adapter;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.sf.jsr107cache.Cache;
import org.ctoolkit.restapi.client.provider.LocalResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCachedResourceProvider<T>
implements LocalResourceProvider<T> {
    private static final Logger logger = LoggerFactory.getLogger(GetCachedResourceProvider.class);
    private final Cache cache;

    @Inject
    public GetCachedResourceProvider(Cache cache) {
        this.cache = cache;
    }

    public final T get(Object identifier, Map<String, Object> parameters, Locale locale, Date lastModifiedDate) {
        Preconditions.checkNotNull((Object)identifier);
        String key = this.composeKey(identifier, locale);
        if (!this.cache.containsKey((Object)key)) {
            return null;
        }
        return (T)this.cache.get((Object)key);
    }

    public final void persist(@Nonnull T instance, Object identifier, Map<String, Object> parameters, Locale locale) {
        Preconditions.checkNotNull(instance);
        Preconditions.checkNotNull((Object)identifier);
        String key = this.composeKey(identifier, locale);
        this.cache.put((Object)key, instance);
        logger.info("The " + instance.getClass().getSimpleName() + " has cached with key: " + key);
    }

    public final List<T> list(Map<String, Object> parameters, Locale locale, Date lastModifiedDate) {
        return null;
    }

    public final void persistList(@Nonnull List<T> instance, Map<String, Object> parameters, Locale locale) {
    }

    private String composeKey(@Nonnull Object identifier, @Nullable Locale locale) {
        Preconditions.checkNotNull((Object)identifier);
        StringBuilder builder = new StringBuilder(identifier.toString());
        if (locale != null) {
            builder.append(".");
            builder.append(locale.getLanguage());
            builder.append("_");
            builder.append(locale.getCountry());
        }
        return builder.toString();
    }
}

