/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.behavior;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;

public class VisibleIfModelNotNull
extends Behavior {
    private static final long serialVersionUID = 8251320963734875048L;
    private static VisibleIfModelNotNull INSTANCE = new VisibleIfModelNotNull();
    private final IModel<?> extModel;

    private VisibleIfModelNotNull() {
        this.extModel = null;
    }

    public VisibleIfModelNotNull(@Nonnull IModel<?> model) {
        this.extModel = (IModel)Preconditions.checkNotNull(model);
    }

    public static VisibleIfModelNotNull get() {
        return INSTANCE;
    }

    public void onConfigure(Component component) {
        if (this.extModel == null) {
            component.setVisible(component.getDefaultModelObject() != null);
        } else {
            component.setVisible(this.extModel.getObject() != null);
        }
    }
}

