/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.behavior;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;

public class VisibleIfModelTrue
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static VisibleIfModelTrue INSTANCE = new VisibleIfModelTrue();
    private final IModel<Boolean> extModel;

    private VisibleIfModelTrue() {
        this.extModel = null;
    }

    public VisibleIfModelTrue(@Nonnull IModel<Boolean> extModel) {
        this.extModel = (IModel)Preconditions.checkNotNull(extModel);
    }

    public static VisibleIfModelTrue get() {
        return INSTANCE;
    }

    public void onConfigure(Component component) {
        Boolean visible = this.extModel == null ? (Boolean)component.getDefaultModelObject() : (Boolean)this.extModel.getObject();
        Preconditions.checkNotNull((Object)visible, (Object)"The model cannot return null value.");
        component.setVisible(visible.booleanValue());
    }
}

