/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.cache;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.sf.jsr107cache.Cache;
import org.apache.wicket.resource.IPropertiesFactoryContext;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.PropertiesFactory;
import org.apache.wicket.util.collections.ConcurrentHashSet;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachePropertiesFactory
extends PropertiesFactory {
    private static final Logger logger = LoggerFactory.getLogger(MemcachePropertiesFactory.class);
    private final Cache memcache;
    private Set<String> include = new ConcurrentHashSet();

    public MemcachePropertiesFactory(@Nonnull IPropertiesFactoryContext context, @Nonnull Cache memcache, @Nonnull Set<String> include) {
        super((IPropertiesFactoryContext)Preconditions.checkNotNull((Object)context));
        this.memcache = (Cache)Preconditions.checkNotNull((Object)memcache);
        this.include = new ConcurrentHashSet((Collection)Preconditions.checkNotNull(include));
    }

    public Properties load(Class<?> clazz, String path) {
        if (!this.include.contains(path)) {
            return null;
        }
        Map localCache = this.getCache();
        Properties properties = (Properties)localCache.get(path);
        if (properties == Properties.EMPTY_PROPERTIES) {
            properties = null;
        }
        if (properties != null) {
            return properties;
        }
        ValueMap valueMap = (ValueMap)this.memcache.get((Object)path);
        if (valueMap != null) {
            properties = new Properties(path, valueMap);
            logger.info("ValueMap taken from memcache for key: '" + path + "'");
        }
        if (properties == null && (properties = super.load(clazz, path)) != null) {
            ValueMap map = properties.getAll();
            if (map != null) {
                this.memcache.put((Object)path, (Object)map);
                logger.info("Properties ValueMap has been put to the memcache with key: '" + path + "'");
            } else {
                logger.warn("Retrieved ValueMap is null for key: '" + path + "'");
            }
        }
        return properties;
    }
}

