/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.wicket.standard.cache;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.jsr107cache.Cache;
import org.apache.wicket.core.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.resource.IResourceStream;
import org.ctoolkit.wicket.standard.cache.MemcacheResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcacheResourceLocator
extends ResourceStreamLocator {
    private static final Logger logger = LoggerFactory.getLogger(MemcacheResourceLocator.class);
    private final Cache memcache;
    private final Map<String, IResourceStream> localCache;
    private final Map<String, String> pathMapper;

    public MemcacheResourceLocator(@Nonnull List<IResourceFinder> finders, @Nonnull Cache memcache) {
        this(finders, memcache, null);
    }

    public MemcacheResourceLocator(@Nonnull List<IResourceFinder> finders, @Nonnull Cache memcache, @Nullable Map<String, String> mapper) {
        super((List)Preconditions.checkNotNull(finders));
        this.memcache = (Cache)Preconditions.checkNotNull((Object)memcache);
        this.localCache = new ConcurrentHashMap<String, IResourceStream>();
        this.pathMapper = mapper == null ? null : new ConcurrentHashMap<String, String>(mapper);
    }

    public IResourceStream locate(Class<?> clazz, String path, String style, String variation, Locale locale, String extension, boolean strict) {
        String cacheKey = this.createCacheKey(path, extension, locale);
        Object resourceStream = this.localCache.get(cacheKey);
        if (resourceStream != null) {
            return resourceStream;
        }
        try {
            resourceStream = (IResourceStream)this.memcache.get((Object)cacheKey);
            logger.info("ResourceStream taken from memcache for key: '" + cacheKey + "'");
            if (resourceStream != null && !this.localCache.containsKey(cacheKey)) {
                this.localCache.put(cacheKey, (IResourceStream)resourceStream);
            }
        }
        catch (Exception e) {
            resourceStream = null;
            logger.warn("Retrieval from the memcache has failed for key: '" + cacheKey + "'", (Throwable)e);
        }
        if (resourceStream != null) {
            return resourceStream;
        }
        if (this.pathMapper != null && this.pathMapper.containsKey(path)) {
            String newPath = this.pathMapper.get(path);
            resourceStream = super.locate(clazz, newPath, null, null, locale, extension, strict);
        }
        if (resourceStream != null) {
            resourceStream = new MemcacheResourceStream((IResourceStream)resourceStream);
            this.memcache.put((Object)cacheKey, resourceStream);
            this.localCache.put(cacheKey, (IResourceStream)resourceStream);
            logger.info("ResourceStream has been put to the memcache with key: '" + cacheKey + "'");
        } else {
            resourceStream = super.locate(clazz, path, null, null, locale, extension, strict);
            if (resourceStream != null) {
                resourceStream = new MemcacheResourceStream((IResourceStream)resourceStream);
                this.memcache.put((Object)cacheKey, resourceStream);
                this.localCache.put(cacheKey, (IResourceStream)resourceStream);
                logger.info("ResourceStream has been put to the memcache with key: '" + cacheKey + "'");
            }
        }
        return resourceStream;
    }

    private String createCacheKey(@Nonnull String path, @Nullable String extension, @Nullable Locale locale) {
        StringBuilder buffer = new StringBuilder(path);
        if (!Strings.isNullOrEmpty((String)extension)) {
            buffer.append("_");
            buffer.append(extension);
        }
        if (locale != null) {
            buffer.append("_");
            buffer.append(locale.getLanguage());
        }
        return buffer.toString();
    }
}

